


local libvenuscore = require "libvenuscore"
local CommandBase = require "venuscore.command.command"
local ContentManager = require "apolloengine.content.contentmanager"
local DeleteComponentCommand = CommandBase:extend("DeleteComponentCommand");

function DeleteComponentCommand:new(nodeUUID,comType)
  DeleteComponentCommand.super.new(self);
  self._nodeUUID = nodeUUID;
  self._comType = comType;
end


function DeleteComponentCommand:DoIt()
  self:BeginCmd();
  if self._nodeUUID then
    local object = self:GetContent(self._nodeUUID);
    if object then
      --保存下之前的UUID，undo的时候创建一个相同ID的component
      local component = object:GetComponent(self._comType);
      self._comUUID = component:GetStaticID();
      object:DeleteComponent(self._comType);
      collectgarbage();
    end
  end
  self:EndCmd();
end

function DeleteComponentCommand:Undo()
  self:BeginCmd();
  local component = nil;
  if self._nodeUUID then
    local object = self:GetContent(self._nodeUUID);
    if object then
      component = object:CreateComponent(self._comType);
      component:SetStaticID(self._comUUID);
    end
  end
  self:EndCmd();
  return component;
end


return DeleteComponentCommand;
