


local libvenuscore = require "libvenuscore"
local apollocore = require "apollocore"
local apolloengine = require "apolloengine"
local CommandBase = require "venuscore.command.command"
local ContentManager = require "apolloengine.content.contentmanager"
local CreateRenderComponentCommand = CommandBase:extend("CreateRenderComponentCommand");
 
           
function CreateRenderComponentCommand:new(nodeUUID)
  CreateRenderComponentCommand.super.new(self);
  self._nodeUUID = nodeUUID;
  self._comUUID = ContentManager:GenerateUUID();
end


function CreateRenderComponentCommand:DoIt()
  self:BeginCmd();
  local component = nil;
  if self._nodeUUID then
    local node = self:GetContent(self._nodeUUID);
    if node then
      component = node:CreateComponent(apollocore.Node.CT_RENDER);
      component:PushMetadata(apollocore.RenderObjectMeshFileMetadate(
          apollocore.VertexBufferEntity.MU_DYNAMIC, 
          "comm:documents/mesh/default.dynamicmesh"));
      component:CreateResource();
      if self._comUUID then
        component:Awake();
        component:SetStaticID(self._comUUID);
      end
    end
  end
  self:EndCmd();
  return component;
end

function CreateRenderComponentCommand:Undo()
  self:BeginCmd();
  if self._nodeUUID then
    local node = self:GetContent(self._nodeUUID);
    if node then
      node:DeleteComponent(apollocore.Node.CT_RENDER);
    end
  end
  self:EndCmd();
end


return CreateRenderComponentCommand;
