


local libvenuscore = require "libvenuscore"
local apollocore = require "apollocore"
local apolloengine = require "apolloengine"
local CommandBase = require "venuscore.command.command"
local ContentManager = require "apolloengine.content.contentmanager"
local CreateClothComponentCommand = CommandBase:extend("CreateClothComponentCommand");
 
           
function CreateClothComponentCommand:new(nodeUUID)
  CreateClothComponentCommand.super.new(self);
  self._nodeUUID = nodeUUID;
  self._comUUID = ContentManager:GenerateUUID();
end


function CreateClothComponentCommand:DoIt()
  self:BeginCmd();
  local component = nil;
  if self._nodeUUID then
    local node = self:GetContent(self._nodeUUID);
    if node then
      component = node:CreateComponent(apollocore.Node.CT_CLOTH);
      component:Initialize();
    end
    if self._comUUID then
      component:Awake();
      component:SetStaticID(self._comUUID);
    end
  end
  self:EndCmd();
  return component;
end

function CreateClothComponentCommand:Undo()
  self:BeginCmd();
  if self._nodeUUID then
    local node = self:GetContent(self._nodeUUID);
    if node then
      node:DeleteComponent(apollocore.Node.CT_RENDER);
    end
  end
  self:EndCmd();
end


return CreateClothComponentCommand;
