

--创建默认相机component的命令
local libvenuscore = require "libvenuscore"
local apollocore = require "apollocore"
local mathfunction = require "mathfunction"
local CommandBase = require "venuscore.command.command"
local ContentManager = require "apolloengine.content.contentmanager"
local CreateDCComponentCommand = CommandBase:extend("CreateDCComponentCommand");

function CreateDCComponentCommand:new(nodeUUID)
  CreateDCComponentCommand.super.new(self);
  self._nodeUUID = nodeUUID;
  self._comUUID = ContentManager:GenerateUUID();
end


function CreateDCComponentCommand:DoIt()
  self:BeginCmd();
  local component = nil;
  if self._nodeUUID then
    local node = self:GetContent(self._nodeUUID);
    if node then
      component = node:CreateComponent(apollocore.Node.CT_CAMERA);
      if self._comUUID then
        component:Awake();
        component:SetStaticID(self._comUUID);
        component:CreatePerspectiveProjection(0.1, 10);
        component:LookAt(mathfunction.vector3(0,0,1), mathfunction.vector3(0,0,0), mathfunction.vector3(0,1,0));
        component:Recalculate();--手动更新矩阵
        component:Activate();--激活主摄像机
      end
    end
  end
  self:EndCmd();
  return component;
end

function CreateDCComponentCommand:Undo()
  self:BeginCmd();
  if self._nodeUUID then
    local node = self:GetContent(self._nodeUUID);
    if node then
      node:DeleteComponent(apollocore.Node.CT_CAMERA);
    end
  end
  self:EndCmd();
end


return CreateDCComponentCommand;
