


local libvenuscore = require "libvenuscore"
local RttiManager = require "venuscore.rtti.rttimanager"
local CommandBase = require "venuscore.command.command"
local ContentManager = require "apolloengine.content.contentmanager"
local segmentAwake = require"apolloengine.components.segment_component";
local CreateComponentCommand = CommandBase:extend("CreateComponentCommand");

function CreateComponentCommand:new(nodeUUID,comType)
  CreateComponentCommand.super.new(self);
  self._nodeUUID = nodeUUID;
  self._comUUID = ContentManager:GenerateUUID();
  self._comType = comType;
end



function CreateComponentCommand:DoIt()
  self:BeginCmd();
  local component = nil;
  if self._nodeUUID then
    local node = self:GetContent(self._nodeUUID);
    if node then
      if type(self._comType) == "string" then  --通过RTTI创建
        component = RttiManager:Newinstance(self._comType,node);
        self._comType = component:GetComponentType();
      else
        component = node:CreateComponent(self._comType);
      end
      if self._comUUID then
        component:Awake();
        component:SetStaticID(self._comUUID);
      end
    end
  end
  self:EndCmd();
  return component;
end

function CreateComponentCommand:Undo()
  self:BeginCmd();
  if self._nodeUUID then
    local node = self:GetContent(self._nodeUUID);
    if node then
      node:DeleteComponent(self._comType);
    end
  end
  self:EndCmd();
end


return CreateComponentCommand;
