


local libvenuscore = require "libvenuscore"
local CommandBase = require "venuscore.command.command"
local ContentManager = require "venuscore.command.content_manager"
local AttachNodeCommand = CommandBase:extend("AttachNodeCommand");

function AttachNodeCommand:new(rootNodeUUID,childNodeUUID)
  AttachNodeCommand.super.new(self);
  self._rootNodeUUID = rootNodeUUID;
  self._childNodeUUID = childNodeUUID;
end


function AttachNodeCommand:DoIt()
  self:BeginCmd();
  if self._rootNodeUUID then
    if self._childNodeUUID then
      local rootNode = self:GetContent(self._rootNodeUUID);
      local childNode = self:GetContent(self._childNodeUUID);
      if rootNode and childNode then
        rootNode:AttachNode(childNode);
        local preRoot = childNode:GetRoot();
        if preRoot:GetTypeName() ~= "Actor" then
          self._preRootUUID = preRoot:GetStaticID();
        end
      end
    end
  else
    if self._childNodeUUID then
      local rootNode = self:GetScene():GetRootNode();
      local childNode = self:GetContent(self._childNodeUUID);
      if rootNode and childNode then
        rootNode:AttachNode(childNode);
        local preRoot = childNode:GetRoot();
        if preRoot:GetTypeName() ~= "Actor" then
          self._preRootUUID = preRoot:GetStaticID();
        end
      end
    end
  end
  self:EndCmd();
end

function AttachNodeCommand:Undo()
  self:BeginCmd();
  if self._childNodeUUID then
    local childNode = self:GetContent(self._childNodeUUID);
    if self._preRootUUID then
      local preRootNode = self:GetContent(self._preRootUUID);
      if preRootNode and childNode then
        preRootNode:AttachNode(childNode);  --挂回原来的root上
      end
    else
      local rootNode = self:GetContent(self._rootNodeUUID);
      if rootNode and childNode then
        rootNode:DetachNode(childNode);
      end
    end
  end
  self:EndCmd();
end

return AttachNodeCommand;
