local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local filelfs = require "window.editor.widget.assets.fileutility"
local CommandBase = require "venuscore.command.command"
local ContentManager = require "venuscore.command.content_manager"
local MorphComponentSetChannelPercentsCommand = CommandBase:extend("MorphComponentSetChannelPercentsCommand");

function MorphComponentSetChannelPercentsCommand:new(uuid, channel, percent)
  MorphComponentSetChannelPercentsCommand.super.new(self);
  self._uuid = uuid;
  self.channel = channel ;
  self.percent = percent ;
end

function MorphComponentSetChannelPercentsCommand:DoIt()
  self:BeginCmd();
  if self._uuid then
    local morphCom = self:GetContent(self._uuid);
    if morphCom then
      morphCom:SetChannelPercents(self.channel, self.percent);
    end
  end
  self:EndCmd();
end

function MorphComponentSetChannelPercentsCommand:Undo()
  self:BeginCmd();
  if self._uuid then
    local morphCom = self:GetContent(self._uuid);
    if morphCom then
      morphCom:SetChannelPercents(self.channel, self.percent);
    end
  end
  self:EndCmd();
end

return MorphComponentSetChannelPercentsCommand;