


local libvenuscore = require "libvenuscore"
local CommandBase = require "venuscore.command.command"
local ContentManager = require "venuscore.command.content_manager"
local GetSetCommand = CommandBase:extend("GetSetCommand");

function GetSetCommand:new(uuid,parameters,setFunc,getFunc)
  GetSetCommand.super.new(self);
  self._uuid = uuid;
  self._setFunc = setFunc
  self._getFunc = getFunc;
  self._data = parameters; --参数
end


function GetSetCommand:DoIt()
  self:BeginCmd();
  if self._uuid then
    local object = self:GetContent(self._uuid);
    if object then
      self._preData = {self._getFunc(object)};
      if self._data ~= nil then
        self._setFunc(object,unpack(self._data));
      else
        self._setFunc(object);
      end
    end
  end
  self:EndCmd();
end

function GetSetCommand:Undo()
  self:BeginCmd();
  if self._uuid then
    local object = self:GetContent(self._uuid);
    if object then
      if #self._preData == 0 then  --没有参数
        self._setFunc(object)
      else
        self._setFunc(object,unpack(self._preData));
      end
    end
  end
  self:EndCmd();
end

return GetSetCommand;
