local libvenuscore = require "libvenuscore"
local CommandBase = require "venuscore.command.command"
local ContentManager = require "venuscore.command.content_manager"
local Stringsplit = require "stringsplit"

local SetFrameCommand = CommandBase:extend("SetFrameCommand");


function SetFrameCommand:new(uuid,keyName,value,index)
    SetFrameCommand.super.new(self);
    self._uuid = uuid;
    self._keynames = Stringsplit(keyName,".")
    self._value = value;
    self._indexes = index;
end
  
  
function SetFrameCommand:DoIt()
    if self._uuid then
        local com = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
        if com then
            local obj = self:GetObj(com,self._keynames);
            local lastkey = self._keynames[#self._keynames];

            if type(obj[lastkey]) == "table" then
                obj[lastkey][self._indexes[#self._indexes]] = self._value;
                self._preValue = obj[lastkey][self._indexes[#self._indexes]];
            else
                self._preValue = obj[lastkey]; --之前值
                local mat44 = obj[lastkey];
                mat44:SetTransform(self._value);
                obj[lastkey] = mat44;
            end
            obj:AutoCaculateFrameBasedONFrameAPOS();
        end
    end
end
  
  function SetFrameCommand:GetObj(com,keys)
    local ret = com;
    for i=1,#keys-1 do
      if type(ret[keys[i]]) == "table" then
        ret = ret[keys[i]][self._indexes[i]];
      else
        ret = ret[keys[i]];
      end
    end
    return ret;
  end
  
  function SetFrameCommand:Undo()
   
  end

return SetFrameCommand