local libvenuscore = require "libvenuscore"
local CommandBase = require "venuscore.command.command"
local ContentManager = require "venuscore.command.content_manager"
local AddConstraintCommand = CommandBase:extend("AddConstraintCommand");
local constraint;

function AddConstraintCommand:new(uuid, constraint)
  AddConstraintCommand.super.new(self);
  self._uuid = uuid;
  self._constraint = constraint;
end

function AddConstraintCommand:DoIt()
  self:BeginCmd();
  if self._uuid then
    local com = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    if com then
	    self._preValue = self._constraint
      constraint = com:AddConstraint(self._constraint)
    end
  end
  self:EndCmd();
end

function AddConstraintCommand:Undo()
  self:BeginCmd();
  if self._uuid then
    local com = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    if com then
      constraint = com:AddConstraint(self._preValue)
    end
  end
  self:EndCmd();
end

return AddConstraintCommand, constraint ;