


local libvenuscore = require "libvenuscore"
local CommandBase = require "venuscore.command.command"
local ContentManager = require "venuscore.command.content_manager"
local FunctionCommand = CommandBase:extend("FunctionCommand");

function FunctionCommand:new(uuid,parameters,setFunc,getFunc)
  FunctionCommand.super.new(self);
  self._uuid = uuid;
  self._setFunc = setFunc
  self._getFunc = getFunc;
  self._data = parameters; --参数
end


function FunctionCommand:DoIt()
  self:BeginCmd();
  if self._uuid then
    local object = self:GetContent(self._uuid);
    if object then
      if self._getFunc then
        self._preData = {self._getFunc(object)};
      end
      self._setFunc(object,unpack(self._data));
    end
  end
  self:EndCmd();
end

function FunctionCommand:Undo()
  self:BeginCmd();
  if self._uuid then
    local object = self:GetContent(self._uuid);
    if object then
      if #self._preData == 0 then  --没有参数
        self._setFunc(object)
      else
        self._setFunc(object,unpack(self._preData));
      end
    end
  end
  self:EndCmd();
end

return FunctionCommand;
