local libvenuscore = require "libvenuscore"
local CommandBase = require "venuscore.command.command"
local ContentManager = require "venuscore.command.content_manager"
local ComponentGetFunctionCommand = CommandBase:extend("ComponentGetFunctionCommand");

function ComponentGetFunctionCommand:new(uuid,doFunc)
  ComponentGetFunctionCommand.super.new(self);
  self._uuid = uuid;
  self._doFunc = doFunc;
end


function ComponentGetFunctionCommand:DoIt()
  if self._uuid then
    local frameAniCom = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    if frameAniCom then
        return self._doFunc(frameAniCom,unpack({}));
    end
  end
end

function ComponentGetFunctionCommand:Undo()
   if self._uuid then
      local frameAniCom = self:GetContent(self._uuid); 
      if frameAniCom then
          return self._doFunc(frameAniCom,unpack({}));
      end
   end
end

return ComponentGetFunctionCommand;