local libvenuscore = require "libvenuscore"
local CommandBase = require "venuscore.command.command"
local ContentManager = require "apolloengine.content.contentmanager"
local AniEntityProchangeCmd = CommandBase:extend("AniEntityProchangeCmd");

function AniEntityProchangeCmd:new(uuid,aniEntityIndex,propertyKey,preValue,setValue)
  AniEntityProchangeCmd.super.new(self);
  self._uuid = uuid;
  self._aniEntityIndex = aniEntityIndex;
  self._propertyKey = propertyKey;
  self._preValue = preValue;
  self._setValue = setValue;
end

function AniEntityProchangeCmd:DoIt()
  self:BeginCmd();
  if self._uuid then
    local frameAniCom = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    if frameAniCom then
      local aniEntity = frameAniCom:GetAniEntity(self._aniEntityIndex);
      if aniEntity then
        aniEntity[self._propertyKey] = self._setValue;
      end
    end
  end
  self:EndCmd();
end

function AniEntityProchangeCmd:Undo()
  self:BeginCmd();
  if self._uuid then
    local frameAniCom = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    if frameAniCom then
      local aniEntity = frameAniCom:GetAniEntity(self._aniEntityIndex);
      if aniEntity then
        aniEntity[self._propertyKey] = self._preValue;
      end
    end
  end
  self:EndCmd();
end

return AniEntityProchangeCmd;
