local libvenuscore = require "libvenuscore"
local CommandBase = require "venuscore.command.command"
local ContentManager = require "venuscore.command.content_manager"
local AniEntityFunctionCommand = CommandBase:extend("AniEntityFunctionCommand");

function AniEntityFunctionCommand:new(uuid,aniEntityIndex,doParams,doFunc,undoParams,undoFunc)
  AniEntityFunctionCommand.super.new(self);
  self._uuid = uuid;
  self._aniEntityIndex = aniEntityIndex
  self._doFunc = doFunc;
  self._undoFunc = undoFunc;
  self._doParams = doParams;
  self._undoParams = undoParams;
end


function AniEntityFunctionCommand:DoIt()
  if self._uuid then
    --local object = self:GetContent(self._uuid);
    --if object then
    --  self._doFunc(object,unpack(self._doParams));
    --end
    
    local frameAniCom = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    if frameAniCom then
      local aniEntity = frameAniCom:GetAniEntity(self._aniEntityIndex);
      if aniEntity and self._doFunc then
        return self._doFunc(aniEntity,unpack(self._doParams));
      end
    end
    
  end
end

function AniEntityFunctionCommand:Undo()
  if self._uuid then
    --local object = self:GetContent(self._uuid);
    --if object and self._undoFunc then
    --  self._undoFunc(object,unpack(self._undoParams));
    --end
    local frameAniCom = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    if frameAniCom then
      local aniEntity = frameAniCom:GetAniEntity(self._aniEntityIndex);
      if aniEntity and self._undoFunc then
        self._undoFunc(aniEntity,unpack(self._undoParams));
      end
    end
  end
end

return AniEntityFunctionCommand;