


local libvenuscore = require "libvenuscore"
local apollocore = require "apollocore"
local apolloengine = require "apolloengine"
local CommandBase = require "venuscore.command.command"
local ContentManager = require "venuscore.command.content_manager"
local DeleteNodeCommand = CommandBase:extend("DeleteNodeCommand");

function DeleteNodeCommand:new(sceneID,doFunc,undoFunc)
  DeleteNodeCommand.super.new(self);
  self._sceneID = sceneID;
  self._doFunc = doFunc;
  self._undoFunc = undoFunc;
end


function DeleteNodeCommand:DoIt()
  local node = nil;
  self:BeginCmd();
  local scene = apolloengine.SceneManager:GetScene(self._sceneID);
  if scene then
    node = self._doFunc(scene);
    if node then
      self._staticID = node:GetContentPath();
    end
  end
  self:EndCmd();
  return node;
end

function DeleteNodeCommand:Undo()
  self:BeginCmd();
  local scene = apolloengine.SceneManager:GetScene(self._sceneID);
  if scene and self.__staticID then
    local node = scene:GetNodeByStaticID(self._staticID);
    return self._undoFunc(scene,node);
  end
  self:EndCmd();
end

return DeleteNodeCommand;
