


local libvenuscore = require "libvenuscore"
local apollocore = require "apollocore"
local CommandBase = require "venuscore.command.command"
local ContentManager = require "venuscore.command.content_manager"
local CreateNodeCommand = CommandBase:extend("CreateNodeCommand");


function CreateNodeCommand:new(nodeID,doFunc,undoFunc)
  CreateNodeCommand.super.new(self);
  self._nodeID = nodeID;
  self._doFunc = doFunc;
  self._undoFunc = undoFunc;
end


function CreateNodeCommand:DoIt()
  local node = nil;
  self:BeginCmd();
  local scene = self:GetScene();
  if scene then
    node = self._doFunc(scene,self._nodeID);
    node:SetStaticID(self._nodeID);
  end
  
  self:EndCmd();
  return node;
end

function CreateNodeCommand:Undo()
  self:BeginCmd();
  local scene = self:GetScene();
  if scene then
    local node = self:GetContent(self._nodeID);
    if node then
      return self._undoFunc(scene,node);
    end
  end
  self:EndCmd();
end

--走到这里说明在Snc场景时触发了嵌套的消息
--trigger cmd 是触发场景（主场景）的命令
function CreateNodeCommand:Sync(triggerCmd)
  self._nodeID = triggerCmd._nodeID;
end


return CreateNodeCommand;
