local CommandBase = require "venuscore.command.command"
local SetSimulateCommand = CommandBase:extend("SetSimulateCommand");

function SetSimulateCommand:new(uuid, bSim)
    SetSimulateCommand.super.new(self);
    self._uuid = uuid;
    self._bSim = bSim;
end

function SetSimulateCommand:DoIt()
    self:BeginCmd();
    if self._uuid then
      local com = self:GetContent(self._uuid);
      if com then
        com:SetSimulate(self._bSim);
      end
    end
    self:EndCmd();
end

function SetSimulateCommand:Undo()
    self:BeginCmd();
    if self._uuid then
      local com = self:GetContent(self._uuid);
      if com then
        com:SetSimulate(not self._bSim);
      end
    end
    self:EndCmd();
end

return SetSimulateCommand;