local CommandBase = require "venuscore.command.command"
local SetMaxDistanceCommand = CommandBase:extend("SetMaxDistanceCommand");

function SetMaxDistanceCommand:new(uuid, dist)
    SetMaxDistanceCommand.super.new(self);
    self._uuid = uuid;
    self._dist = dist;
end

function SetMaxDistanceCommand:DoIt()
    self:BeginCmd();
    if self._uuid then
      local com = self:GetContent(self._uuid);
      if com then
        self._prev = com:GetMaxDistance();
        com:SetMaxDistance(self._dist);
      end
    end
    self:EndCmd();
end

function SetMaxDistanceCommand:Undo()
    self:BeginCmd();
    if self._uuid then
        local com = self:GetContent(self._uuid);
        if com then
          com:SetMaxDistance(self._prev);
        end
    end
    self:EndCmd();
end

return SetMaxDistanceCommand;