local CommandBase = require "venuscore.command.command"
local SetCapsuleColliderCommand = CommandBase:extend("SetCapsuleColliderCommand");

function SetCapsuleColliderCommand:new(uuid, index, nodeId)
    SetCapsuleColliderCommand.super.new(self);
    self._uuid = uuid;
    self._index = index;
    self._nodeId = nodeId;
end

function SetCapsuleColliderCommand:DoIt()
    if self._uuid then
      local com = self:GetContent(self._uuid);
      if com then
        self._prev = com:GetCapsule(self._index);
        local node = self:GetContent(self._nodeId);
        com:SetCapsule(self._index, node);
      end
    end
end

function SetCapsuleColliderCommand:Undo()
    if self._uuid then
        local com = self:GetContent(self._uuid);
        if com then
           com:SetCapsule(self._index, self._prev);
        end
    end
end

return SetCapsuleColliderCommand;