local CommandBase = require "venuscore.command.command"
local SetAnchorIDCommand = CommandBase:extend("SetAnchorIDCommand");

function SetAnchorIDCommand:new(uuid, anchorId, nodeId)
    SetAnchorIDCommand.super.new(self);
    self._uuid       = uuid;
    self._anchorId   = anchorId;
    self._nodeId     = nodeId;
    self._prevNodeId = -1;
end

function SetAnchorIDCommand:DoIt()
	self:BeginCmd();
    if self._uuid then
        local com = self:GetContent(self._uuid);
        local anchor = com:GetAnchor(self._anchorId);
        if anchor ~= nil then
            self._prevNodeId = anchor.AnchorId;
            anchor.AnchorId  = self._nodeId;
            anchor.IsInit    = false;
        end
        
    end
    self:EndCmd();
end

function SetAnchorIDCommand:Undo()
	self:BeginCmd();
    if self._uuid then
        local com = self:GetContent(self._uuid);
        local anchor = com:GetAnchor(self._anchorId);
        if anchor ~= nil then
            anchor.AnchorId = self._prevNodeId;
            anchor.IsInit   = false;
        end
    end
    self:EndCmd();
end

return SetAnchorIDCommand;