local CommandBase = require "venuscore.command.command"
local SetAnchorBodyCommand = CommandBase:extend("SetAnchorBodyCommand");

function SetAnchorBodyCommand:new(uuid, anchorId, bodyId)
    SetAnchorBodyCommand.super.new(self);
    self._uuid       = uuid;
    self._anchorId   = anchorId;
    self._bodyId     = bodyId;
    self._prevBodyId = -1;
end

function SetAnchorBodyCommand:DoIt()
		self:BeginCmd();
    if self._uuid then
        local com = self:GetContent(self._uuid);
        local anchor = com:GetAnchor(self._anchorId);
        if anchor ~= nil then
            if anchor.AnchorBody then
                self._prevBodyId = anchor.AnchorBody:GetStaticID();
            end
            anchor.AnchorBody = self:GetContent(self._bodyId);
            anchor.IsInit = false;
        end
    end
    self:EndCmd();
end

function SetAnchorBodyCommand:Undo()
		self:BeginCmd();
    if self._uuid then
        local com = self:GetContent(self._uuid);
        local anchor = com:GetAnchor(self._anchorId);
        if anchor ~= nil then
            if anchor.AnchorBody ~= nil then
                anchor.AnchorBody = self:GetContent(self._prevBodyId);
            end
        end
    end
    self:EndCmd();
end

return SetAnchorBodyCommand;