local CommandBase = require "venuscore.command.command"
local DeleteCapsuleColliderCommand = CommandBase:extend("DeleteCapsuleColliderCommand");

function DeleteCapsuleColliderCommand:new(uuid)
    DeleteCapsuleColliderCommand.super.new(self);
    self._uuid = uuid;
    self._deleteId = -1;
end

function DeleteCapsuleColliderCommand:DoIt()
		self:BeginCmd();
    if self._uuid then
      local com = self:GetContent(self._uuid);
      if com then
        local delCapsule = com:PopCapsule();
        self._deleteId   = delCapsule:GetStaticID();
      end
    end
    self:EndCmd();
end

function DeleteCapsuleColliderCommand:Undo()
		self:BeginCmd();
    if self._uuid then
        local com = self:GetContent(self._uuid);
        if com then
          com:ResizeCapsules();
          if self._deleteId ~= -1 then
              local nCount = com:GetCapsuleCount();
              local prev = self:GetContent(self._deleteId);
              com:SetCapsule(nCount-1, prev);
          end
        end
    end
    self:EndCmd();
end

return DeleteCapsuleColliderCommand;