local CommandBase = require "venuscore.command.command"
local DeleteAnchorCommand = CommandBase:extend("DeleteAnchorCommand");

function DeleteAnchorCommand:new(uuid)
    DeleteAnchorCommand.super.new(self);
    self._uuid = uuid;
    self._prevbodyId = -1;
end

function DeleteAnchorCommand:DoIt()
		self:BeginCmd();
    if self._uuid then
      local com = self:GetContent(self._uuid);
      if com then
        local nAnchors = com:GetAnchorCount();
        local anchor   = com:GetAnchor(nAnchors-1);
        self._previd   = anchor.AnchorId;

        if anchor.AnchorBody ~= nil then
            self._prevbodyId = anchor.AnchorBody:GetStaticID();
        end

        com:RemoveAnchor(anchor);
      end
    end
    self:EndCmd();
end

function DeleteAnchorCommand:Undo()
		self:BeginCmd();
    if self._uuid then
        local com = self:GetContent(self._uuid);
        if com then
            local anchor = com:CreateAnchor();
            if self._prevbodyId ~= -1 then
              anchor.AnchorBody = self:GetContent(self._prevbodyId);
            end
            anchor.AnchorId = self._previd;
        end
    end
    self:EndCmd();
end

return DeleteAnchorCommand;