local CommandBase = require "venuscore.command.command"
local BrushDistanceConstraintCommand = CommandBase:extend("BrushDistanceConstraintCommand");

function BrushDistanceConstraintCommand:new(uuid, nodes)
    BrushDistanceConstraintCommand.super.new(self);
    self._uuid = uuid;
    self._selectedNodes = nodes;
end

function BrushDistanceConstraintCommand:DoIt()
    self:BeginCmd();
    if self._uuid then
      local com = self:GetContent(self._uuid);
      if com then
        self._prev = com:GetCurrentSelectedMaxDistance(self._selectedNodes);
        com:SetNodesConstraints(self._selectedNodes);
      end
    end
    self:EndCmd();
end

function BrushDistanceConstraintCommand:Undo()
    self:BeginCmd();
    if self._uuid then
        local com = self:GetContent(self._uuid);
        if com then
          com:SetCurrentSelectedMaxDistance(self._prev);
        end
    end
    self:EndCmd();
end

return BrushDistanceConstraintCommand;