local CommandBase = require "venuscore.command.command"
local AppendAnchorCommand = CommandBase:extend("AppendAnchorCommand");

function AppendAnchorCommand:new(uuid, anchorId)
    AppendAnchorCommand.super.new(self);
    self._uuid = uuid;
    self._anchorId = anchorId;
end

function AppendAnchorCommand:DoIt()
    self:BeginCmd();
    if self._uuid then
      local com = self:GetContent(self._uuid);
      if com then
        local anchor = com:GetAnchor(self._anchorId);
        if anchor ~= nil then
            com:AppendAnchor(anchor);
            anchor.IsInit = true;
        end
      end
    end
    self:EndCmd();
end

function AppendAnchorCommand:Undo()
    self:BeginCmd();
    if self._uuid then
        local com = self:GetContent(self._uuid);
        if com then
            local anchor = com:GetAnchor(self._anchorId);
            if anchor ~= nil then
                anchor.IsInit = false;
            end
        end
    end
    self:EndCmd();
end

return AppendAnchorCommand;