local CommandBase = require "venuscore.command.command"
local AddCapsuleColliderCommand = CommandBase:extend("AddCapsuleColliderCommand");

function AddCapsuleColliderCommand:new(uuid)
    AddCapsuleColliderCommand.super.new(self);
    self._uuid = uuid;
end

function AddCapsuleColliderCommand:DoIt()
		self:BeginCmd();
    if self._uuid then
      local com = self:GetContent(self._uuid);
      if com then
        com:ResizeCapsules();
      end
    end
    self:EndCmd();
end

function AddCapsuleColliderCommand:Undo()
		self:BeginCmd();
    if self._uuid then
        local com = self:GetContent(self._uuid);
        if com then
          com:PopCapsule();
        end
    end
    self:EndCmd();
end

return AddCapsuleColliderCommand;