local CommandBase = require "venuscore.command.command"
local AddAnchorCommand = CommandBase:extend("AddAnchorCommand");

function AddAnchorCommand:new(uuid)
    AddAnchorCommand.super.new(self);
    self._uuid = uuid;
end

function AddAnchorCommand:DoIt()
		self:BeginCmd();
    if self._uuid then
      local com = self:GetContent(self._uuid);
      if com then
        self._anchor = com:CreateAnchor();
      end
    end
    self:EndCmd();
end

function AddAnchorCommand:Undo()
		self:BeginCmd();
    if self._uuid then
        local com = self:GetContent(self._uuid);
        if com then
          com:RemoveAnchor(self._anchor);
        end
    end
    self:EndCmd();
end

return AddAnchorCommand;