local libvenuscore = require "libvenuscore"
local CommandBase = require "venuscore.command.command"
local ContentManager = require "apolloengine.content.contentmanager"
local PostEffectPropertyChangeCommand = CommandBase:extend("PostEffectPropertyChangeCommand");

function PostEffectPropertyChangeCommand:new(uuid,postEffEntityIndex,propertyKey,preValue,setValue)
  PostEffectPropertyChangeCommand.super.new(self);
  self._uuid = uuid;
  self._postEffEntityIndex = postEffEntityIndex;
  self._propertyKey = propertyKey;
  self._preValue = preValue;
  self._setValue = setValue;
end

function PostEffectPropertyChangeCommand:DoIt()
  self:BeginCmd();
  if self._uuid then
    local camera = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    if camera then
		local posteffeceList = camera.PosteffectEntities;
		local postentity = posteffeceList[self._postEffEntityIndex];
		if postentity then
			postentity:SetParameter(self._propertyKey, self._setValue);
		end
    end
  end
  self:EndCmd();
end

function PostEffectPropertyChangeCommand:Undo()
  self:BeginCmd();
  if self._uuid then
    local camera = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    if camera then
		local posteffeceList = camera.PosteffectEntities;
		local postentity = posteffeceList[self._postEffEntityIndex];
		if postentity then
			postentity:SetParameter(self._propertyKey, self._preValue);
		end
    end
  end
  self:EndCmd();
end

return PostEffectPropertyChangeCommand;
