local libvenuscore = require "libvenuscore"
local CommandBase = require "venuscore.command.command"
local ContentManager = require "apolloengine.content.contentmanager"
local LayerMaskCommand = CommandBase:extend("LayerMaskCommand");

function LayerMaskCommand:new(uuid,isadd,value)
  LayerMaskCommand.super.new(self);
  self._uuid = uuid;
  self._isadd = isadd;
  self._value = value;
end

function LayerMaskCommand:DoIt()
  self:BeginCmd();
  if self._uuid then
    local camera = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    if camera then
      if self._isadd == true then
        camera:AddLayerMask(self._value);
      else
        camera:EraseLayerMask(self._value);
      end
    end
  end
  self:EndCmd();
end

function LayerMaskCommand:Undo()
  self:BeginCmd();
  if self._uuid then
    local camera = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    if camera then
      if self._isadd == true then
        camera:EraseLayerMask(self._value);
      else
        camera:AddLayerMask(self._value);
      end
    end
  end
  self:EndCmd();
end

return LayerMaskCommand;
