local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local CommandBase = require "venuscore.command.command"
local ContentManager = require "apolloengine.content.contentmanager"
local DelPostEffectCommand = CommandBase:extend("DelPostEffectCommand");

function DelPostEffectCommand:new(uuid,srcrptPath,postEffEntityIndex,Queue)
  DelPostEffectCommand.super.new(self);
  self._uuid = uuid;
  self._srcrptPath = srcrptPath;
  self._postEffEntityIndex = postEffEntityIndex;
  self._Queue = Queue;
end

function DelPostEffectCommand:DoIt()
  self:BeginCmd();
  if self._uuid then
    local camera = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    if camera then
	  local posteffeceList = camera.PosteffectEntities;
      if posteffeceList then
        local postentity = posteffeceList[self._postEffEntityIndex];
        if postentity then
           camera:DeletePostEffect(postentity);
        end
      end
    end
  end
  self:EndCmd();
end

function DelPostEffectCommand:Undo()
  self:BeginCmd();
  local component = nil;
  if self._uuid then
    local camera = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    if camera then
      local post = camera:CreatePostEffect();
      post:PushMetadata(apolloengine.PathMetadata(self._srcrptPath));
      post:CreateResource();
      post.Queue = self._Queue;	
    end
  end
  self:EndCmd(); 
end

return DelPostEffectCommand;
