local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local CommandBase = require "venuscore.command.command"
local ContentManager = require "apolloengine.content.contentmanager"
local AttachRenderTargetCommand = CommandBase:extend("AttachRenderTargetCommand");

--[[
function AttachRenderTargetCommand:new(uuid,preValue,setValue)
  AttachRenderTargetCommand.super.new(self);
  self._uuid = uuid;
  self._preValue = preValue;
  self._setValue = setValue;
end
]]--

function AttachRenderTargetCommand:new(uuid,fboPath)
  AttachRenderTargetCommand.super.new(self);
  self._uuid = uuid;
  self._fboPath = fboPath;
end


function AttachRenderTargetCommand:DoIt()
  self:BeginCmd();
  if self._uuid then
    local camera = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    if camera then
      local curfbo = apolloengine.RenderTargetEntity();
      local metaData = apolloengine.RenderTargetFileMetadata(self._fboPath);
      curfbo:PushMetadata(metaData);
      curfbo:CreateResource();
      camera:AttachRenderTarget(curfbo);
    end
  end
  self:EndCmd();
end

function AttachRenderTargetCommand:Undo()
  self:BeginCmd();
  if self._uuid then
    local camera = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    if camera then
     camera:AttachRenderTarget(self._preValue);
    end
  end
  self:EndCmd();
end

return AttachRenderTargetCommand;
