local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local CommandBase = require "venuscore.command.command"
local ContentManager = require "apolloengine.content.contentmanager"
local AddPostEffectCommand = CommandBase:extend("AddPostEffectCommand");

function AddPostEffectCommand:new(uuid,srcrptPath)
  AddPostEffectCommand.super.new(self);
  self._uuid = uuid;
  self._srcrptPath = srcrptPath;
  self._postEffEntityIndex = nil;
end

function AddPostEffectCommand:DoIt()
  self:BeginCmd();
  local component = nil;
  if self._uuid then
    local camera = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    if camera then
	  local post = camera:CreatePostEffect();
      post:PushMetadata(apolloengine.PathMetadata(self._srcrptPath));
      post:CreateResource();
      local posteffeceList = camera.PosteffectEntities;
      if posteffeceList then
      post.Queue = #posteffeceList;	
      self._postEffEntityIndex = #posteffeceList;	
      end
    end
  end
  self:EndCmd();
end

function AddPostEffectCommand:Undo()
  self:BeginCmd();
  if self._uuid then
    local camera = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    if camera then
	  local posteffeceList = camera.PosteffectEntities;
	   if posteffeceList then
		  local postentity = posteffeceList[self._postEffEntityIndex];
		  if postentity then
			camera:DeletePostEffect(postentity);
		  end
	  end
    end
  end
  self:EndCmd();
end

return AddPostEffectCommand;
