local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local filelfs = require "window.editor.widget.assets.fileutility"
local CommandBase = require "venuscore.command.command"
local ContentManager = require "venuscore.command.content_manager"
local AnimationSetCurveCommand = CommandBase:extend("AnimationSetCurveCommand");

function AnimationSetCurveCommand:new(uuid, aniname, bindobjuuid, bindname, newcurve)
  AnimationSetCurveCommand.super.new(self);
  self._uuid = uuid;
  self._bindObjuuid = bindobjuuid;
  self._aniName =  aniname;
  self._bindName = bindname;
  self._newCurve = newcurve;
end

function AnimationSetCurveCommand:DoIt()
  self:BeginCmd();
  if self._uuid and self._bindObjuuid then
    local ani = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    local bindObj = self:GetContent(self._bindObjuuid);
    if ani and bindObj then
      ani:SetCurve(self._aniName, bindObj, self._bindName, self._newCurve);
    end
  end
  self:EndCmd();
end

function AnimationSetCurveCommand:Undo()
  self:BeginCmd();
  self:EndCmd();
end

return AnimationSetCurveCommand