local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local filelfs = require "window.editor.widget.assets.fileutility"
local CommandBase = require "venuscore.command.command"
local ContentManager = require "venuscore.command.content_manager"
local AnimationSetColorCommand = CommandBase:extend("AnimationSetColorCommand");

function AnimationSetColorCommand:new(uuid, bindobjuuid, aniname, bindname, colorindex)
  AnimationSetColorCommand.super.new(self);
  self._uuid = uuid;
  self._bindObjuuid = bindobjuuid;
  self._aniName =  aniname;
  self._bindName = bindname;
  self._colorIndex = colorindex;
end

function AnimationSetColorCommand:DoIt()
  self:BeginCmd();
  if self._uuid and self._bindObjuuid then
    local ani = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    local bindObj = self:GetContent(self._bindObjuuid);
    if ani and bindObj then
      self._preColor = ani:GetColorIndex(bindObj, self._aniName, self._bindName);
      ani:SetColorIndex(bindObj, self._aniName, self._bindName, self._colorIndex);
    end
  end
  self:EndCmd();
end

function AnimationSetColorCommand:Undo()
  self:BeginCmd();
  if self._uuid and self._bindObjuuid then
    local ani = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    local bindObj = self:GetContent(self._bindObjuuid);
    if ani and bindObj then
      ani:SetColorIndex(bindObj, self._aniName, self._bindName, self._preColor);
    end
  end
  self:EndCmd();
end

return AnimationSetColorCommand;