local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local filelfs = require "window.editor.widget.assets.fileutility"
local CommandBase = require "venuscore.command.command"
local ContentManager = require "venuscore.command.content_manager"
local AnimationResetCommand = CommandBase:extend("AnimationResetCommand");

function AnimationResetCommand:new(uuid, aniname)
  AnimationResetCommand.super.new(self);
  self._uuid = uuid;
  self._aniName =  aniname;
end

function AnimationResetCommand:DoIt()
  self:BeginCmd();
  if self._uuid then
    local ani = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    if ani then
      ani:Reset(self._aniName);
    end
  end
  self:EndCmd();
end

function AnimationResetCommand:Undo()
  self:BeginCmd();
  self:EndCmd();
end

return AnimationResetCommand;