local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local filelfs = require "window.editor.widget.assets.fileutility"
local CommandBase = require "venuscore.command.command"
local ContentManager = require "venuscore.command.content_manager"
local AnimationLoopCommand = CommandBase:extend("AnimationLoopCommand");

function AnimationLoopCommand:new(uuid, aniname, loopvalue)
  AnimationLoopCommand.super.new(self);
  self._uuid = uuid;
  self._aniName =  aniname;
  self._loopValue = loopvalue;
end

function AnimationLoopCommand:DoIt()
  self:BeginCmd();
  if self._uuid then
    local ani = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    if ani then
      self._preLoopValue = not self._loopValue;
      ani:Loop(self._aniName, self._loopValue);
    end
  end
  self:EndCmd();
end

function AnimationLoopCommand:Undo()
  self:BeginCmd();
  if self._uuid then
    local ani = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    if ani then
      ani:Loop(self._aniName, self._preLoopValue);
    end
  end
  self:EndCmd();
end

return AnimationLoopCommand;