local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local filelfs = require "window.editor.widget.assets.fileutility"
local CommandBase = require "venuscore.command.command"
local ContentManager = require "venuscore.command.content_manager"
local AnimationDeleteCurveCommand = CommandBase:extend("AnimationDeleteCurveCommand");

function AnimationDeleteCurveCommand:new(uuid, bindobjuuid, aniname, bindname)
  AnimationDeleteCurveCommand.super.new(self);
  self._uuid = uuid;
  self._aniName =  aniname;
  self._bindObjuuid = bindobjuuid;
  self._bindName = bindname;
end

function AnimationDeleteCurveCommand:DoIt()
  self:BeginCmd();
  if self._uuid then
    local ani = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    local bindObj = self:GetContent(self._bindObjuuid);
    if ani and bindObj then
      ani:Stop(self._aniName);
      ani:Reset(self._aniName);
      ani:DeleteCurve(bindObj, self._aniName, self._bindName);
    end
  end
  self:EndCmd();
end

function AnimationDeleteCurveCommand:Undo()
  self:BeginCmd();
  if self._uuid then
    local ani = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    local bindObj = self:GetContent(self._bindObjuuid);
    if ani and bindObj then
      ani:CreateCurve(self._aniName, bindObj, self._bindName);
    end
  end
  self:EndCmd();
end

return AnimationDeleteCurveCommand;