local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local filelfs = require "window.editor.widget.assets.fileutility"
local CommandBase = require "venuscore.command.command"
local ContentManager = require "venuscore.command.content_manager"
local AddAnimationCommand = CommandBase:extend("AddAnimationCommand");

function AddAnimationCommand:new(uuid, anipath)
  AddAnimationCommand.super.new(self);
  self._uuid = uuid;
  self._aniPath =  anipath;
end

function AddAnimationCommand:DoIt()
  self:BeginCmd();
  if self._uuid then
    local ani = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
    if ani then
      local meta = apolloengine.EditorKeyFrameMetaData(self._aniPath);
      local sceneid = self:GetSceneID();
      meta:SetSceneID(sceneid);
      ani:PushMetadata(meta);
      ani:CreateResource();
    end
  end
  self:EndCmd();
end

function AddAnimationCommand:Undo()
  self:BeginCmd();
  self:EndCmd();
end

return AddAnimationCommand;