


local libvenuscore = require "libvenuscore"
local ContentManager = require "venuscore.command.content_manager"
local apolloengine = require "apolloengine"
local stringsplit = require "stringsplit"
local Command = libvenuscore.Object:extend("Command");

function Command:new()
  --命令是否处于正在执行过程中
  self.IsExcuting = false;  
  --是否是同步类型的命令
  self.IsSyncCommand = false;
end

function Command:SetSceneID(sceneID)
  self.sceneID = sceneID;
end

function Command:GetSceneID()
  return self.sceneID;
end

function Command:GetScene()
  return apolloengine.SceneManager:GetSceneById(self.sceneID);
end

function Command:SetSyncType()
  self.IsSyncCommand = true;
end

function Command:IsSyncType()
  return self.IsSyncCommand;
end

--uuid可能是多级的
--NodeID/ComponnetID
function Command:GetContent(uuid)
  local content = nil;
  local scene = apolloengine.SceneManager:GetSceneById(self.sceneID);
  if scene then
    local idPathList = stringsplit(uuid, "/");
    local idLevelCnt = #idPathList;
    if idLevelCnt == 1 then  --NodeID
      content = scene:GetNode(idPathList[1]);
    elseif idLevelCnt == 2 then  --ComponentID
      local node = scene:GetNode(idPathList[1]);
      if node then
        content = node:GetComponent(idPathList[2]);
      end
    else
      ERROR("Invalid uuid");
    end
  end
  return content;
end

function Command:BeginCmd()
  self.IsExcuting = true;
end

function Command:EndCmd()
  self.IsExcuting = false;
end

--像其他场景同步时候的回调
function Command:Sync()
  LOG("Default Sync");
end


--命令是否执行完成
function Command:IsFinished()
  return not self.IsExcuting;
end


function Command._SearchScriptInst(inst, keys)
  local target = inst
  local targetKey = keys[1]
  for i = 1, #keys - 1 do
    if target.GetScriptValue then
      target = target:GetScriptValue(targetKey)
    else
      target = target[targetKey]
    end
    targetKey = keys[i + 1]
  end
  return target, targetKey
end

return Command;
