local Serializer = require "venuscore.bundle.fserializer.fserializer"
local FDatatype = require "venuscore.bundle.fserializer.fdatatype"

local apollocore = require "apollocore"
local venuscore = require "libvenuscore"

local SerializationTool = {};

function SerializationTool:GetAttribute(decoder, parentName)
  local attributes = {};
  local typeName = decoder:AsString(1);
  local isTable = false;
  attributes["__typename"] = typeName;
  if typeName == "table" then
    isTable = true;
  end
  local memberListCnt = decoder:GetLength();
  for i = 2, memberListCnt do
    local fieldName = decoder:GetFieldName(i);
    local fieldType = decoder:GetFieldType(i);
    local fieldValue = nil;
    if fieldType == FDatatype.DT_BOOL then
      fieldValue = decoder:AsBool(i);
    elseif fieldType == FDatatype.DT_INT then
      fieldValue = decoder:AsInt(i);
    elseif fieldType == FDatatype.DT_FLOAT then
      fieldValue = decoder:AsFloat(i);
    elseif fieldType == FDatatype.DT_DOUBLE then
      fieldValue = decoder:AsDouble(i);
    elseif fieldType == FDatatype.DT_STRING then
      fieldValue = decoder:AsString(i);
    elseif fieldType == FDatatype.DT_CLASS then
      local childDecoder = decoder:AsClass(i);
      fieldValue = self:GetAttribute(childDecoder, fieldName);
    elseif fieldType == FDatatype.DT_REFERENCE then
      fieldValue = {};
      fieldValue["__typename"] = venuscore.ScriptTypes.ReferenceTypeName;
      fieldValue["refid"] = decoder:AsString(i);
      fieldValue["fieldName"] = fieldName;
      fieldValue["fieldCount"] = memberListCnt - 1;
      fieldValue["parentName"] = parentName;
      fieldValue["number"] = i - 1;
    end
    if fieldValue ~= nil then
      attributes[fieldName] = fieldValue;
    end
  end
  return attributes;
end

function SerializationTool:_SerializeCls(cls, encoder)
  local fieldName = cls["fieldname"];
  local typename = cls["typename"];
  local members = cls["members"];
  local value = cls["value"];
  local __reference_uuid = cls["__reference_uuid"];
  encoder:SetFieldString("typename", typename);  --类型
  if __reference_uuid then
    encoder:SetFieldString("__reference_uuid", __reference_uuid);
  end
  local memberCnt = #members;
  for i = 1, memberCnt do
    local member = members[i];
    local memberFieldName = member["fieldname"];
    local memberTypeName = member["typename"];
    local memberValue = member["value"];
    local childMembers = member["members"];
    if memberTypeName ~= "number"
            and memberTypeName ~= "boolean"
            and memberTypeName ~= "string"
            and memberTypeName ~= venuscore.ScriptTypes.ReferenceTypeName then
      --class 类型
      local childEncoder = encoder:GetChild();
      local childFieldName = self:_SerializeCls(member, childEncoder);  --class field 给一个key name
      encoder:SetFieldClass(childFieldName, childEncoder);
    else
      if memberTypeName == "number" then
        encoder:SetFieldFloat(memberFieldName, memberValue);
      elseif memberTypeName == "boolean" then
        encoder:SetFieldBool(memberFieldName, memberValue);
      elseif memberTypeName == "string" then
        encoder:SetFieldString(memberFieldName, memberValue);
      elseif memberTypeName == venuscore.ScriptTypes.ReferenceTypeName then
        encoder:SetFieldReference(memberFieldName, memberValue);
      end
    end
  end
  return fieldName;
end

function SerializationTool:GetDecoder(bufferAsString)
  local serializer = Serializer();
  local decoder = serializer:GetDecoderFromBuffer(bufferAsString);
  return decoder, serializer:GetVersion();
end

return SerializationTool;