local mathfunction = require "mathfunction"
local apollocore = require "apollocore"
local venuscore = require "libvenuscore"
local MemberIterator = require "venuscore.rtti.mpairs"
local RttiManager = require "venuscore.rtti.rttimanager"
local BundleSystem = require "venuscore.bundle.bundlesystem"
local PrefabTool = require "venuscore.bundle.serialization.prefabtool"
local libvenuscore = require "libvenuscore"
local spinefunction = require "spinefunction"
local Deserialization = {};

Deserialization.version = 1;
local EditorSceneName = "Scene"
--创建对象
function Deserialization:_InstantiationCls(typename, host, key)
  local cls = nil;
  if typename == "table" then
    --lua table 类型
    cls = {};
  elseif typename == venuscore.ScriptTypes.ReferenceTypeName then
    --如果是引用类型
    LOG("reference type");
  else
    --rtti manager创建对象
    if host ~= nil and BundleSystem.DeserializeInitDelegates[host:GetTypeName()] then
      cls = RttiManager:Newinstance(typename, host, BundleSystem.CurrentScene);
      if cls == nil then
        local func = BundleSystem.DeserializeInitDelegates[host:GetTypeName()];
        cls = func(host, typename, key);
      end
    else
      cls = RttiManager:Newinstance(typename, host, BundleSystem.CurrentScene);
    end
  end
  return cls;
end

function Deserialization:_Attributes(cls, attributes, nodes, referenceinfo)
  if attributes.__reference_uuid then
    referenceinfo.nodemap[attributes.__reference_uuid] = cls;
    if cls and cls.SetStaticID and BundleSystem.CurrentDeserializeMode == BundleSystem.DeserializeMode.Scene then
      --if attributes.__reference_uuid == "" then
      local staticID = attributes.__reference_uuid;
      local _beg,_end = string.find(attributes.__reference_uuid,"table: ");
      if _beg and _end then
        staticID = string.sub(attributes.__reference_uuid,_end + 1);
      end
      
      cls:SetStaticID(staticID);
      --cls:SetStaticID(attributes.__reference_uuid);
    end
    attributes.__reference_uuid = nil;
  end
  if cls and cls.GetTypeName then
    local typename = cls:GetTypeName();
    if BundleSystem.DeserializeDelegates[typename] then
      --自定义了实例化函数
      local func = BundleSystem.DeserializeDelegates[typename];
      func(cls, attributes, nodes);
      --table.insert(nodes,cls);  --实例化出的脚本node加入table中
      return cls;
    elseif type(cls) == "table" and cls:is(libvenuscore.VenusBehavior) then
      for name, attr in pairs(attributes) do
        cls:SetScriptValue(name,attr);
      end
      return cls;
    end
  end
  
  for name, attr in pairs(attributes) do
    cls[name] = attr;
  end
  
  
  
  return cls;  --再把cls返回回去
end

--收集类型信息，主要从类的注册属性中查找,table类型特殊处理，ChildNodes也是特例?
function Deserialization:_CollectAttributes(attributes, dataType, cls, host, nodes, referenceinfo)
  local clsMembers = {};
  if cls ~= nil then
    if dataType == "table" or type(cls) == "table" then
      for key, value in pairs(attributes) do
        if key ~= "__typename" then
          if type(attributes[key]) == "table" then
            local keyNum = tonumber(key) or key;
            clsMembers[key] = BundleSystem:GetDeserializationCallback(attributes[key]["__typename"])(attributes[key], host, cls[keyNum], keyNum, nodes, referenceinfo, cls);
          else
            clsMembers[key] = attributes[key];
          end
        end
      end
    else
      for key, handle in MemberIterator(cls) do
        if attributes[key] ~= nil then
          if type(attributes[key]) == "table" then
            clsMembers[key] = BundleSystem:GetDeserializationCallback(attributes[key]["__typename"])(attributes[key], cls, cls[key], key, nodes, referenceinfo, cls);
          else
            clsMembers[key] = attributes[key];
          end
        end
      end
    end
  end

  if attributes["__reference_uuid"] ~= nil then
    clsMembers["__reference_uuid"] = attributes["__reference_uuid"];
  end
  return clsMembers;
end

BundleSystem:RegisterDeserialization("Default",
        function(attributes, host, cls, key, nodes, referenceinfo)
          local dataType = attributes["__typename"];
          --LOG(dataType .. "deserialize!!");
          if cls == nil then
            cls = Deserialization:_InstantiationCls(dataType, host, key);
          end
          local clsMembers = Deserialization:_CollectAttributes(attributes, dataType, cls, host, nodes, referenceinfo);
          return Deserialization:_Attributes(cls, clsMembers, nodes, referenceinfo);
        end
);

BundleSystem:RegisterDeserialization(apollocore.RenderComponent:GetTypeName(),
        function(attributes, host, cls, key, nodes, referenceinfo)
          return BundleSystem:GetDeserializationCallback("Default")(attributes, host, cls, key, nodes, referenceinfo);
        end
);

BundleSystem:RegisterDeserialization(apollocore.Scene:GetTypeName(),
        function(attributes, host, cls, key, nodes, referenceinfo)
          local dataType = attributes["__typename"];
          cls = apollocore.SceneManager:CreateScene(EditorSceneName)
          local clsMembers = {};
          if cls ~= nil then
            for key, handle in MemberIterator(cls) do
              if attributes[key] ~= nil then
                if type(attributes[key]) ~= "table" then
                  clsMembers[key] = attributes[key];
                end
              end
            end
          end
          if attributes["__reference_uuid"] ~= nil then
            clsMembers["__reference_uuid"] = attributes["__reference_uuid"];
          end
          
          return Deserialization:_Attributes(cls, clsMembers, nodes, referenceinfo);
        end
);

--ParticleNode的序列化还借助PrticleNode实现
BundleSystem:RegisterDeserialization(apollocore.CPUEmitter:GetTypeName(),
        function(attributes, host, cls, key, nodes, referenceinfo)
          local dataType = attributes["__typename"];
          if cls == nil then
            cls = host:CreateParticleNode():GetNativeNode();
          end
          return BundleSystem:GetDeserializationCallback(apollocore.Node:GetTypeName())(attributes, host, cls, key, nodes, referenceinfo);
        end
);


BundleSystem:RegisterDeserialization(spinefunction.SpineNode:GetTypeName(),
        function(attributes, host, cls, key, nodes, referenceinfo)
          local dataType = attributes["__typename"];
          if cls == nil then
            cls = host:CreateSpineNode():GetNativeNode();
          end
          return BundleSystem:GetDeserializationCallback(apollocore.Node:GetTypeName())(attributes, host, cls, key, nodes, referenceinfo);
        end
);

BundleSystem:RegisterDeserialization(apollocore.TextNode:GetTypeName(),
        function(attributes, host, cls, key, nodes, referenceinfo)
          if attributes["Version"] == 2 then
            local dataType = attributes["__typename"];
            if cls == nil then
              cls = Deserialization:_InstantiationCls(dataType, host, key);
            end
            table.insert(nodes,1,cls);
            local clsMembers = {};
            local childNodes = {};
            if cls ~= nil then
              for key, handle in MemberIterator(cls) do
                if key ~= "ChildNodes" then
                  if attributes[key] ~= nil then
                    if type(attributes[key]) == "table" then
                      clsMembers[key] = BundleSystem:GetDeserializationCallback(attributes[key]["__typename"])(attributes[key], cls, cls[key], key, nodes, referenceinfo, cls);
                    else
                      clsMembers[key] = attributes[key];
                    end
                  end
                end
              end
              for key, handle in MemberIterator(attributes["ChildNodes"]) do
                if key ~= "__typename" then
                  childNodes[key] = BundleSystem:GetDeserializationCallback(handle["__typename"])(handle, host, nil, key, nodes, referenceinfo, cls);
                end
              end
            end
            clsMembers["ChildNodes"] = childNodes;
            if attributes["__reference_uuid"] ~= nil then
              clsMembers["__reference_uuid"] = attributes["__reference_uuid"];
            end
            return Deserialization:_Attributes(cls, clsMembers, nodes, referenceinfo);
          elseif attributes["Version"] == 1 then
            return BundleSystem:GetDeserializationCallback("Default")(attributes, host, cls, key, nodes, referenceinfo);
          else
            return BundleSystem:GetDeserializationCallback("Default")(attributes, host, cls, key, nodes, referenceinfo);
          end
        end
);

BundleSystem:RegisterDeserialization(apollocore.Node:GetTypeName(),
        function(attributes, host, cls, key, nodes, referenceinfo)
          if attributes["Version"] == 2 then
            local dataType = attributes["__typename"];
            if cls == nil then
              cls = Deserialization:_InstantiationCls(dataType, host, key);
            end
            table.insert(nodes,1,cls);
            local clsMembers = {};
            local childNodes = {};
            if cls ~= nil then
              for key, handle in MemberIterator(cls) do
                if key ~= "ChildNodes" then
                  if attributes[key] ~= nil then
                    if type(attributes[key]) == "table" then
                      clsMembers[key] = BundleSystem:GetDeserializationCallback(attributes[key]["__typename"])(attributes[key], cls, cls[key], key, nodes, referenceinfo, cls);
                    else
                      clsMembers[key] = attributes[key];
                    end
                  end
                end
              end
              for key, handle in MemberIterator(attributes["ChildNodes"]) do
                if key ~= "__typename" then
                  childNodes[key] = BundleSystem:GetDeserializationCallback(handle["__typename"])(handle, host, nil, key, nodes, referenceinfo, cls);
                end
              end
            end
            clsMembers["ChildNodes"] = childNodes;
            if attributes["__reference_uuid"] ~= nil then
              clsMembers["__reference_uuid"] = attributes["__reference_uuid"];
            end
            return Deserialization:_Attributes(cls, clsMembers, nodes, referenceinfo);
          elseif attributes["Version"] == 1 then
            return BundleSystem:GetDeserializationCallback("Default")(attributes, host, cls, key, nodes, referenceinfo);
          else
            return BundleSystem:GetDeserializationCallback("Default")(attributes, host, cls, key, nodes, referenceinfo);
          end
        end
);

BundleSystem:RegisterDeserialization(apollocore.MaterialMetadata:GetTypeName(),
        function(attributes, host, cls, key, nodes, referenceinfo)
          if not attributes["Version"] or attributes["Version"] == 1 then  --旧版本材质
            local dataType = attributes["__typename"];
            if cls == nil then
              cls = Deserialization:_InstantiationCls(dataType, host, key);
            end
            local clsMembers = {};
            if cls ~= nil then
              for key, handle in pairs(attributes) do
                if key ~= "__typename" then
                  if type(attributes[key]) == "table" then
                    clsMembers[key] = BundleSystem:GetDeserializationCallback(attributes[key]["__typename"])(attributes[key], cls, cls[key], key, nodes, referenceinfo, cls);
                  else
                    clsMembers[key] = handle;  --这里可能会有问题(如果被删除的属性是一个C++对象，那这里就会有问题了)
                                               --按照版本兼容的原则，不需要的属性是不应该删掉的，但是材质这边都是完全删掉了
                                               --只能hack
                  end
                end
              end
            end
            if attributes["__reference_uuid"] ~= nil then
              clsMembers["__reference_uuid"] = attributes["__reference_uuid"];
            end
            return Deserialization:_Attributes(cls, clsMembers, nodes, referenceinfo);
          else
            return BundleSystem:GetDeserializationCallback("Default")(attributes, host, cls, key, nodes, referenceinfo);
          end
        end
);

BundleSystem:RegisterDeserialization(apollocore.MaterialEntity:GetTypeName(),
        function(attributes, host, cls, key, nodes, referenceinfo)
          if not attributes["Version"] or attributes["Version"] == 1 then  --旧版本材质
            local dataType = attributes["__typename"];
            if cls == nil then
              cls = Deserialization:_InstantiationCls(dataType, host, key);
            end
            local clsMembers = {};
            if cls ~= nil then
              for key, handle in pairs(attributes) do
                if key ~= "__typename" then
                  clsMembers[key] = BundleSystem:GetDeserializationCallback(attributes[key]["__typename"])(attributes[key], cls, cls[key], key, nodes, referenceinfo, cls);
                  if key == "SourceMetadata" then
                    clsMembers["ShaderPath"] = handle[1]["ShaderPath"];
                  end
                end
              end
            end
            if attributes["__reference_uuid"] ~= nil then
              clsMembers["__reference_uuid"] = attributes["__reference_uuid"];
            end
            return Deserialization:_Attributes(cls, clsMembers, nodes, referenceinfo);
          else
            return BundleSystem:GetDeserializationCallback("Default")(attributes, host, cls, key, nodes, referenceinfo);
          end
        end
);

BundleSystem:RegisterDeserialization(venuscore.ScriptTypes.ReferenceTypeName,
        function(attributes, host, cls, key, nodes, referenceinfo, parentCls)
          local refid = attributes.refid; --ref类型变为闭包，等待序列化完毕刷包
          local fieldName = attributes.fieldName;
          local fieldCount = attributes.fieldCount;
          local parentName = attributes.parentName;
          local num = attributes.number;
          local callback = {};
          callback.key = refid;
          callback.func = function(value)
            if type(parentCls) == "table" then
              parentCls[fieldName] = value;
              if table.getlength(parentCls) == fieldCount then
                host[parentName] = parentCls;
              end
            else
              host[fieldName] = value;
            end
          end
          table.insert(referenceinfo.callbacks, callback);
        end
);

BundleSystem:RegisterDeserialization(apollocore.RenderObjectMeshMetadate:GetTypeName(),
        function(attributes, host, cls, key, nodes, referenceinfo)
          return nil;
        end
);

BundleSystem:RegisterDeserialization("PrefabNode",
        function(attributes, host, cls, key, nodes, referenceinfo)
          local diff = attributes.Diff;
          local prefabPath = attributes.PrefabPath;
          local diffInfo = PrefabTool:UnserializeTable(diff);
          local originPrefabInfo = PrefabTool:ReadPrefabInfo(prefabPath);
          if originPrefabInfo == nil then
            ERROR("failed to load prefab, create nothing");
            return nil;
          end
          attributes = PrefabTool:PatchDiff(originPrefabInfo, diffInfo);
          return BundleSystem:GetDeserializationCallback(attributes["__typename"])(attributes, host, cls, key, nodes, referenceinfo);
        end
);

return Deserialization;