
local MemberIterator = require "venuscore.rtti.mpairs"
local RttiManager = require "venuscore.rtti.rttimanager"
local Serializer = require "venuscore.bundle.fserializer.fserializer"
local FDatatype = require "venuscore.bundle.fserializer.fdatatype"
local SerializationTool = require "venuscore.bundle.serialization.serializationtool"
local libvenuscore = require "libvenuscore"


local apollocore = require "apollocore"
local venuscore = require "libvenuscore"
local bit = require("bit")

local PrefabTool = require "venuscore.bundle.serialization.prefabtool"

local BundleSystem = {}
local isPreView = false;
local EditorSceneName = "Scene"
BundleSystem.DeserializeMode =
{
  Prefab = 1,
  Scene = 2
};

BundleSystem.CurrentDeserializeMode = BundleSystem.DeserializeMode.Prefab;
BundleSystem.CurrentScene = nil;

BundleSystem.Version = 2; --版本号

BundleSystem.SerializeDelegates = {};
BundleSystem.DeserializeDelegates = {}
BundleSystem.DeserializeInitDelegates = {};
BundleSystem.SerializeStartedDelegates = {}; --序列化开始的回调
BundleSystem.SerializeFinishedDelegates = {}; --序列化完成的回调
BundleSystem.DeserializeFinishedDelegates = {}; --反序列化完成的回调
BundleSystem.RegisterSerializationDelegates = {};
BundleSystem.RegisterDeserializationDelegates = {};

function BundleSystem:RegisterSerialization(typeName, func)
  assert(not BundleSystem.RegisterSerializationDelegates[typeName]);
  BundleSystem.RegisterSerializationDelegates[typeName] = func;
end

function BundleSystem:RegisterDeserialization(typeName, func)
  assert(not BundleSystem.RegisterDeserializationDelegates[typeName]);
  BundleSystem.RegisterDeserializationDelegates[typeName] = func;
end

function BundleSystem:GetDeserializationCallback(typeName)
  return BundleSystem.RegisterDeserializationDelegates[typeName] or BundleSystem.RegisterDeserializationDelegates["Default"];
end

function BundleSystem:OnSerialize(fieldname, func)
  assert(not BundleSystem.SerializeDelegates[fieldname]);
  BundleSystem.SerializeDelegates[fieldname] = func;
end

function BundleSystem:OnDeserialize(typename, func)
  assert(not BundleSystem.DeserializeDelegates[typename]);
  BundleSystem.DeserializeDelegates[typename] = func;
end

function BundleSystem:OnDeserializeInit(typename, func)
  assert(not BundleSystem.DeserializeInitDelegates[typename]);
  BundleSystem.DeserializeInitDelegates[typename] = func;
end

function BundleSystem:OnSerializeStarted(typename, func)
  assert(not BundleSystem.SerializeStartedDelegates[typename]);
  BundleSystem.SerializeStartedDelegates[typename] = func;
end

function BundleSystem:OnSerializeFinished(typename, func)
  assert(not BundleSystem.SerializeFinishedDelegates[typename]);
  BundleSystem.SerializeFinishedDelegates[typename] = func;
end

function BundleSystem:OnDeserializeFinished(typename, func)
  assert(not BundleSystem.DeserializeFinishedDelegates[typename]);
  BundleSystem.DeserializeFinishedDelegates[typename] = func;
end


--测试打印table
function BundleSystem:ToStr(t,dometatables)
 local function basicToStr (o)
  if type(o) == "number" or type(o)=="boolean" then
   return tostring(o)
  elseif type(o) == "string" then
   return string.format("%q", o)
  else
   return tostring(o) --"nil"
  end
 end
 local strTG = {}
 --local basicToStr= basicSerialize --tostring
 if type(t) ~="table" then  return basicToStr(t) end
 local recG = 0
 local nameG="SELF"..recG
 local ancest ={}
 local function _ToStr(t,strT,rec,name)
  if ancest[t] then
   strT[#strT + 1]=ancest[t]
   return
  end
  rec = rec + 1
  ancest[t]=name
  strT[#strT + 1]='{'
  local count=0
  -------------
  --if t.name then strT[#strT + 1]=string.rep("\t",rec).."name:"..tostring(t.name) end
  ----------------
  for k,v in pairs(t) do
   count=count+1
   strT[#strT + 1]="\n"
   local kstr
   if type(k) == "table" then
    local name2=string.format("%s.KEY%d",name,count)
    strT[#strT + 1]=string.rep("\t",rec).."["
    local strTK = {}
    _ToStr(k,strTK,rec,name2)
    kstr=table.concat(strTK)
    strT[#strT + 1]=kstr.."]="
   else
    kstr = basicToStr(k)
    strT[#strT + 1]=string.rep("\t",rec).."["..kstr.."]="
   end
   
   if type(v) == "table" then
     local name2=string.format("%s[%s]",name,kstr)
     _ToStr(v,strT,rec,name2)
   else
    strT[#strT + 1]=basicToStr(v)
   end
  end
  if dometatables then
   local mt = getmetatable(t)
   if mt then
    local namemt = string.format("%s.METATABLE",name)
    local strMT = {}
    _ToStr(mt,strMT,rec,namemt)
    local metastr=table.concat(strMT)
    strT[#strT + 1] = "\n"..string.rep("\t",rec).."[METATABLE]="..metastr
   end
  end
  strT[#strT + 1]='}'
  rec = rec - 1
  return
 end
 _ToStr(t,strTG,recG,nameG)
 return table.concat(strTG)
end
function BundleSystem:prtable(...)
 for i=1, select('#', ...) do
  local t = select(i, ...)
  print(self:ToStr(t))
  print("\n")
 end
end


--从一个脚本node开始序列化
function BundleSystem:Serialize(root)
  local apollonode = root;
  local rootnode = root;
  
  if root.GetRootNode then
    rootnode = root:GetRootNode();
  end
  
  --开始序列化的通知
  self:SerializeStarted(rootnode);
  

  local serializeInfo = self:_SerializeTraverse(apollonode);

  --self:prtable(serializeInfo);

  --flatbuffer 序列化
  local serializer = Serializer();
  local encoder = serializer:GetEncoder();

  --整个场景应该只有一个根节点
  local cls = serializeInfo[1];
  if cls then
    --序列化版本号
    encoder:SetFieldInt("version",BundleSystem.Version);
    local childEncoder = encoder:GetChild();
    SerializationTool:_SerializeCls(cls,childEncoder);
    encoder:SetFieldClass("Data",childEncoder);
  end
  
  --完成序列化的通知
  self:SerializeFinished(rootnode);

  return serializer:GetBuffer();  --返回序列化结果
end

function BundleSystem:DeserializeScene(path, deserializeMode)
  local nodes = {};
  local referenceinfo = {}
  referenceinfo.nodemap = {}
  referenceinfo.callbacks = {}
  local scene = nil;
  
  local file = io.open(path, "rb");
  local bufferStr = file:read("*a");
  local serializer = Serializer();
  local decoder = serializer:GetDecoderFromBuffer(bufferStr);
  local typename = decoder:AsString(1);
  if typename == "Scene" or typename == "Actor" then
    if serializer.version == 1 then
      scene = apollocore.SceneManager:CreateScene(EditorSceneName);
    elseif serializer.version == 2 then
      scene = self:_DeSerializeCls(decoder, nil, nodes, referenceinfo);
    end
  end
  return scene;
end


function BundleSystem:DeSerialize(bufferAsString, scene, deserializeMode)
  BundleSystem.CurrentDeserializeMode = deserializeMode or BundleSystem.DeserializeMode.Prefab;
  BundleSystem.CurrentScene = scene;
  local nodes = {};
  local referenceinfo = {}
  referenceinfo.nodemap = {}
  referenceinfo.callbacks = {}

  local serializer = Serializer();
  local decoder = serializer:GetDecoderFromBuffer(bufferAsString);
  
  if serializer.version == 1 then
    self:_DeSerializeVer1(decoder, nodes, referenceinfo);
  else
    self:_DeSerializeVer2(decoder, nodes, referenceinfo);
  end
  
  for i, v in ipairs(referenceinfo.callbacks) do
    local obj = referenceinfo.nodemap[v.key];
    if obj then
      v.func(obj);
    else
      ERROR("unkown reference object id: "..v.key);
    end
  end

  for i = 1, #nodes do
    if nodes[i].OnDeserializeFinished then
      nodes[i]:OnDeserializeFinished();
    end
  end

  return nodes;
end

function BundleSystem:_DeSerializeVer1(decoder, nodes, referenceinfo)
   --判断是不是从C++根节点开始序列化的，如果是排除此节点
  --C++内置的根节点不做反序列化
  local typename = decoder:AsString(1);
  if typename == "Actor" then
    local memberListCnt = decoder:GetLength();
    for i = 2, memberListCnt do
      local fieldName = decoder:GetFieldName(i);
      if string.find(fieldName,'ChildNodes') then
        local childDecoder = decoder:AsClass(i);
        self:_DeSerializeCls(childDecoder,nil,nodes, referenceinfo);
      elseif fieldName == "Name" then
        local rootname = decoder:AsString(i);
        local apolloRootNode = BundleSystem.CurrentScene:GetRootNode();
        apolloRootNode:SetName(rootname);
      end
    end
  else
    self:_DeSerializeCls(decoder,BundleSystem.CurrentScene,nodes, referenceinfo);
  end
end

function BundleSystem:_DeSerializeVer2(decoder, nodes, referenceinfo)
  local typename = decoder:AsString(1);
  if typename == "Scene" then
    local memberListCnt = decoder:GetLength();
    for i = 2, memberListCnt do
      local fieldName = decoder:GetFieldName(i);
      if string.find(fieldName,'RootNode') then
        local childDecoder = decoder:AsClass(i);
        local memberListCnt = childDecoder:GetLength();
        for j = 2, memberListCnt do
          local fieldName = childDecoder:GetFieldName(j);
          if string.find(fieldName,'ChildNodes') then
            self:_DeSerializeCls(childDecoder:AsClass(j),BundleSystem.CurrentScene,nodes, referenceinfo);
          elseif fieldName == "Name" then
            local rootname = childDecoder:AsString(j);
            local apolloRootNode = BundleSystem.CurrentScene:GetRootNode();
            apolloRootNode:SetName(rootname);
          end
        end
      end
    end
  else
    self:_DeSerializeCls(decoder,BundleSystem.CurrentScene,nodes, referenceinfo);
  end
end

function BundleSystem:SerializeStarted(apolloNode)
  if apolloNode then
    if apolloNode.OnSerializeStarted ~= nil then
      apolloNode:OnSerializeStarted();
    end
    
    local childList = apolloNode:GetChildrens();
    local childListCnt = #childList;
    for i = 1, childListCnt do
      local childNode = childList[i];
      self:SerializeStarted(childNode);
    end
  end
end

function BundleSystem:SerializeFinished(apolloNode)
  if apolloNode then
    if apolloNode._Script then
      apolloNode._Script:OnSerializeFinished();
    end
    local childList = apolloNode:GetChildrens();
    local childListCnt = #childList;
    for i = 1, childListCnt do
      local childNode = childList[i];
      self:SerializeFinished(childNode);
    end
  end
end

--遍历C++场景，构建序列化信息
function BundleSystem:_SerializeTraverse(apollonode)
  local info = {}
  if apollonode then
    self:_SerializeTraverseNode(apollonode,nil,nil,info); --序列化无脚本的C++node
  end
  if apollonode._Script and apollonode._Script:GetPrefabPath() then
    local prefabPath = apollonode._Script:GetPrefabPath();
    local newInfo = {};
    newInfo[1] = PrefabTool:GenerateSerializationInfo(prefabPath, info[1]);
    return newInfo;
  elseif apollonode.GetPrefabPath and apollonode:GetPrefabPath() ~= "" then
    local prefabPath = apollonode:GetPrefabPath();
    local newInfo = {};
    newInfo[1] = PrefabTool:GenerateSerializationInfo(prefabPath, info[1]);
    return newInfo;
  end
  return info;
end

--decoder: 解码器
--thisCls: 是否需要创建该类型（如果父类中已经生成了此对象则此值非空)
--nodes: 返回值，创建的脚本node都放入此列表中
--host: 当前对象thisCls的父对象（C++对象）
function BundleSystem:_DeSerializeCls(decoder, host, nodes, referenceinfo)
  local typename = decoder:AsString(1);
  local cls = nil;
  local func = BundleSystem:GetDeserializationCallback(typename);
  local attributes = SerializationTool:GetAttribute(decoder);
  cls = func(attributes, host, cls, nil, nodes, referenceinfo, nil);
  return cls;
end

--遍历单个Node构建序列化信息
function BundleSystem:_SerializeTraverseNode(obj,root,rootkey,info)
  local isRef = venuscore.isReference(root, rootkey);
  if isRef then--引用类型，不在进行递归
    local cls = {};
    cls["members"] = {};
    cls["fieldname"] = rootkey;
    if obj == nil then
      return
    end
    if type(obj) == "userdata" then
      cls["typename"] = venuscore.ScriptTypes.ReferenceTypeName;
      cls["value"] = obj:GetStaticID();
    elseif type(obj) == "table" then--table
      if obj.GetTypeName then
        cls["typename"] = venuscore.ScriptTypes.ReferenceTypeName;
        cls["value"] = obj:GetStaticID();
      else
        cls["typename"] = "table";
        for k, v in pairs(obj) do
          local childCls = {};
          childCls["typename"] = venuscore.ScriptTypes.ReferenceTypeName;
          childCls["value"] = v:GetStaticID();
          childCls["fieldname"] = k;
          childCls["members"] = {};
          table.insert(cls["members"], childCls);
        end
      end
    end
    table.insert(info,cls);
  else
    local t = type(obj);
    if t == "userdata" then
      local tm = getmetatable(obj);
      local str = obj:GetTypeName();
      local cls = {};
      if BundleSystem.RegisterSerializationDelegates[str] then
        local func = BundleSystem.RegisterSerializationDelegates[str];
        cls = func(obj, rootkey);
      else
        cls["typename"] = str;
        cls["__reference_uuid"] = obj.GetStaticID and obj:GetStaticID() or nil;
        cls["fieldname"] = rootkey or "";
        cls["members"] = cls["members"] or {};
        table.insert(info,cls);
        for key, handle in MemberIterator(obj) do
          self:_SerializeTraverseNode(obj[key],obj,key,cls["members"]);
        end
      end
    elseif t == "table" then  --脚本序列化
      local str = "";
      local cls = {};
      if obj.GetTypeName then  --脚本node对象
        str = obj:GetTypeName();
      else   --普通table
        str = "table";
      end
      cls["typename"] = str;
      cls["__reference_uuid"] = obj.GetStaticID and obj:GetStaticID() or nil;
      cls["fieldname"] = rootkey or "";
      cls["members"] = cls["members"] or {};
      table.insert(info,cls);
      if obj.GetTypeName then  --从venuscore派生的对象是有注册信息的
        for key, handle in MemberIterator(obj) do
          if obj:is(libvenuscore.VenusBehavior) and obj:GetScriptValue(key) ~= nil then
            info[key] = self:_SerializeTraverseNode(obj:GetScriptValue(key), obj, key,cls["members"]);
          else
            if obj[key] ~= nil then
              info[key] = self:_SerializeTraverseNode(obj[key], obj, key,cls["members"]);
            end  
          end
        end
      else --普通lua table是没有注册信息的
        for key, handle in pairs(obj) do
          --用来处理遍历ChildNodes时候的Layer过滤
          local childObj = obj[key];
          if type(childObj) == "userdata" and childObj.isTypeOrDriverType and childObj:isTypeOrDriverType(apollocore.Node:RTTI()) then
            if not childObj:isLayer(apollocore.LayerMask.MC_MASK_EDITOR_SCENE_LAYER)
              and not childObj:isLayer(apollocore.LayerMask.MC_MASK_EDITOR_UI_LAYER) 
              and not childObj:isLayer(apollocore.LayerMask.MC_MASK_EDITOR_CLOTHDEBUG_LAYER) then
                self:_SerializeTraverseNode(childObj,obj,key,cls["members"]);
            end
          else
            self:_SerializeTraverseNode(childObj,obj,key,cls["members"]);
          end
        end
      end
    elseif t == "number" or t == "boolean" or t == "string" then
      local cls = {};
      cls["typename"] = t;
      cls["fieldname"] = rootkey;
      cls["members"] = {};
      cls["value"] = obj;
      table.insert(info,cls);
    elseif BundleSystem.SerializeDelegates[rootkey] then
      local func = BundleSystem.SerializeDelegates[rootkey];
      local typename,fieldname = func(obj);
      local cls = {};
      cls["typename"] = typename;
      cls["fieldname"] = rootkey;
      cls["members"] = {};
      cls["value"] = fieldname;
      table.insert(info,cls);
    end
  end
end

return BundleSystem;