local mathfunction = require "mathfunction"
local stringsplit = require "stringsplit"
local vc = require "venuscore"
require "math"

function LOG(log)
  vc.ILogSystem:Log(tostring(log));
end
function WARNING(log )
  vc.ILogSystem:Warning(tostring(log));
end
function ERROR( log)
  vc.ILogSystem:Error(tostring(log));
end

 function saveSelf(target,method)
  return function(...)
    return method(target, ...);
  end
 end

function TableToStr(t)
    if t == nil then
        return "nil"
    end
    local str = "{"
    table.foreach(t, function(k, v)
        str = str..tostring(k)
        str = str..":"
        if type(v) == "table" then
            str = str..TableToStr(v)
        else
            str = str..tostring(v)
        end
        str = str..","
    end)
    str = str.."}"
    return str
end

function TableKeysToStr(t)
    if t == nil then
        return "nil"
    end
    local str = "{"
    table.foreach(t, function(k, v)
        str = str..tostring(k)
        str = str..","
    end)
    str = str.."}"
    return str
end

function TableSize(t)
    local s = 0
    for key, _ in pairs(t) do
        s = s + 1
    end
    return s
end

function Print_Table(root)
  local cache = {  [root] = "." }
  local function _dump(t,space,name)
    local temp = {}
    for k,v in pairs(t) do
      local key = tostring(k)
      if cache[v] then
        table.insert(temp,"+" .. key .. " {" .. cache[v].."}")
      elseif type(v) == "table" then
        local new_key = name .. "." .. key
        cache[v] = new_key
        table.insert(temp,"+" .. key .. _dump(v,space .. (next(t,k) and "|" or " " ).. string.rep(" ",#key),new_key))
      else
        table.insert(temp,"+" .. key .. " [" .. tostring(v).."]")
      end
    end
    return table.concat(temp,"\n"..space)
  end
  local function magiclines(s)
        if s:sub(-1)~="\n" then s=s.."\n" end
        return s:gmatch("(.-)\n")
  end
  local str = _dump(root, "","");
  for line in magiclines(str) do
    LOG(line);
  end
end

function Sleep(n)
   if n > 0 then os.execute("ping -n " .. tonumber(n + 1) .. " localhost > NUL") end
end

string.split = function(s, p)
    local rt= {}
    string.gsub(s, '[^'..p..']+', function(w) table.insert(rt, w) end )
    return rt
end

string.caseinsensitive = function (pattern)

  -- find an optional '%' (group 1) followed by any character (group 2)
  local p = pattern:gsub("(%%?)(.)", function(percent, letter)

    if percent ~= "" or not letter:match("%a") then
      -- if the '%' matched, or `letter` is not a letter, return "as is"
      return percent .. letter
    else
      -- else, return a case-insensitive character class of the matched letter
      return string.format("[%s%s]", letter:lower(), letter:upper())
    end

  end)

  return p
end

function math.clamp(v, minValue, maxValue)  
    if v < minValue then
        return minValue
    end
    if( v > maxValue) then
        return maxValue
    end
    return v 
end

function string.tovector(str)  
  local data = stringsplit(str, ",", tonumber);
  if #data == 1 then
    return mathfunction.vector1(data[1]);
  elseif #data == 2 then
    return mathfunction.vector2(data[1],data[2]);
  elseif #data == 3 then
    return mathfunction.vector3(data[1],data[2],data[3]);
  elseif #data == 4 then
    return mathfunction.vector4(data[1],data[2],data[3],data[4]);
  end
  return nil;
end

function CreatEnumTable(tbl, index) --创建枚举table
    local enumtbl = {} 
    local enumindex = index or 0 
    for i, v in ipairs(tbl) do 
        enumtbl[v] = enumindex + i 
    end 
    return enumtbl 
end 
 function CreatCoefTable(tbl)
    local CoefTable = {} 
    for i, v in ipairs(tbl) do 
        CoefTable[i] = 0;
    end 
    return CoefTable;
 end
--print(case_insensitive_pattern("xyz = %d+ or %% end"))
