local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local toning = {}
toning.To = 0;

toning.Queue = 122;

function toning:Initialize(host, size)
  self.RED_TONING =apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"RED_TONING");
  self.GREEN_TONING =apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"GREEN_TONING");
  self.BLUE_TONING =apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"BLUE_TONING");
  self.To = host:CreateRenderObject("comm:documents/filter/material/toning.material");
  self.To:SetParameter(self.RED_TONING, mathfunction.vector4(0.0,0.5198,0.4801,0.0));
  self.To:SetParameter(self.GREEN_TONING, mathfunction.vector4(0.0,0.0,0.9337,0.1175));
  self.To:SetParameter(self.BLUE_TONING, mathfunction.vector4(0.0,-0.1728,1.1728,0.0));
  return self.Queue;
end

function toning:Resizeview(size)
end

function toning:Process(pipeline, Original, Scene, Output)
  Output:PushRenderTarget();
  Output:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  self.To:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
	self.To:Draw(pipeline);
end

return toning;

