local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local mirror = {}
mirror.Mr = 0;

mirror.Queue = 200;

function mirror:Initialize(host, size)
  self.UNIFORM_SCALE =apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"UNIFORM_SCALE");
    
  self.Mr = host:CreateRenderObject("comm:documents/filter/material/mirror.material");
  self.Mr:SetParameter(self.UNIFORM_SCALE, mathfunction.vector1(0.5));
  return self.Queue;
end

function mirror:Resizeview(size)
end

function mirror:Process(pipeline, Original, Scene, Output)
  Output:PushRenderTarget();
  Output:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  self.Mr:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
	self.Mr:Draw(pipeline);
end

return mirror;

