local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local brightnessfilter = {}
brightnessfilter.Bf = 0;
brightnessfilter.Queue = 109;



function brightnessfilter:Initialize(host, size)
    --<!--  set the offsets parameters in vertex shader -->
  self.BRIGHTNESS = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,"BRIGHTNESS");
  self.Bf = host:CreateRenderObject("comm:documents/filter/material/brightnessfilter.material" );
  self.Bf:SetParameter(self.BRIGHTNESS, mathfunction.vector1(0.0));
  --self:_SetParam(size);
  return self.Queue;
end

function brightnessfilter:Resizeview(size)
  --self:_SetParam(size);
end

function brightnessfilter:Process(pipeline, Original, Scene, Output)
  Output:PushRenderTarget();
  Output:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  self.Bf:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
	self.Bf:Draw(pipeline);
end

return brightnessfilter;