local b3 = require 'behavior3.b3';
require 'behavior3.core.Composite'

local memPriority = b3.Class("MemPriority", b3.Composite)
b3.MemPriority = memPriority

function memPriority:ctor()
	b3.Composite.ctor(self)

	self.name = "MemPriority"
end

function memPriority:init(tick)
	tick.nodestage:set("runningChild", 0, tick.tree.id, self.id)
  b3.BaseNode.init(self, tick)
end

function memPriority:tick(tick)
	local child = tick.nodestage:get("runningChild", tick.tree.id, self.id)
	for i,v in ipairs(self.children) do
		local status = v:_execute(tick)

		if status ~= b3.FAILURE then
			if status == b3.RUNNING then
				tick.nodestage:set("runningChild", i, tick.tree.id, self.id)
      else
        tick.nodestage:set("runningChild", 0, tick.tree.id, self.id)
			end
			
			return status
		end
	end
  
  tick.nodestage:set("runningChild", 0, tick.tree.id, self.id)
	return b3.FAILURE
end

function memPriority:reset(tick)
  tick.nodestage:set("runningChild", 0, tick.tree.id, self.id)
  b3.BaseNode.reset(self, tick)
end