

local mathfunction = require "mathfunction"
local apollocore = require "apollocore"
local defined = require "apolloengine.defined"
local BundleSystem = require "venuscore.bundle.bundlesystem"


local _fNativeGetScene = apollocore.SceneManager.GetScene;
local _fNativeCreateScene = apollocore.SceneManager.CreateScene;
local _fNativeGetSceneByID = apollocore.SceneManager.GetSceneById;
local _fNativeDeleteSceneByID = apollocore.SceneManager.DeleteSceneById;
local _fNativeGetAllScene = apollocore.SceneManager.GetAllScenes;



function apollocore.SceneManager:CreateScene(sceneName)
  local scene = _fNativeCreateScene(self,sceneName);
  if _KRATOSEDITOR then
    scene:Init();
    apollocore.SceneManager.EditCamera = scene:CreateEditorCamera();
    apollocore.SceneManager.Grid = scene:CreateGrid();
    apollocore.SceneManager.EditSceneID = scene:GetStaticID();
    scene:SetPhyscisDebugMesh(true);
  end
  return scene;
end




--避免修改facecute
--和之前的GetOrCreate兼容
--这里兼容下用Name索引Scene
apollocore.SceneManager.SceneType2SceneIDList = {};
function apollocore.SceneManager:GetOrCreateScene(sceneType)
  local scene = nil;
  local sceneID = apollocore.SceneManager.SceneType2SceneIDList[sceneType];
  if sceneID then
    scene = _fNativeGetSceneByID(self,sceneID);
  else
    scene = _fNativeCreateScene(self,sceneType);  --直接拿sceneType当名字
    apollocore.SceneManager.SceneType2SceneIDList[sceneType] = scene:GetStaticID();
  end
  return scene;
end

if _KRATOSEDITOR then
  apollocore.SceneManager.PreviewSceneID = nil;
  apollocore.SceneManager.EditSceneID = nil;
  apollocore.SceneManager.EditorUIID = nil;
  apollocore.SceneManager.EditCamera = nil;
  apollocore.SceneManager.Grid = nil;
  apollocore.SceneManager.SyncSceneList = {};
  
  function apollocore.SceneManager:GetEditCamera()
    return apollocore.SceneManager.EditCamera;
  end
  
  function apollocore.SceneManager:GetGrid()
    return apollocore.SceneManager.Grid;
  end
  
  function apollocore.SceneManager:CreatePreviewScene(sceneName)
    local previewScene = _fNativeCreateScene(self,sceneName);
    previewScene:SetSequence(defined.SceneSequence.MID);
    apollocore.SceneManager.PreviewSceneID = previewScene:GetStaticID();
    return previewScene;
  end
  
  function apollocore.SceneManager:GetPreviewScene()
    local previewScene = nil;
    if apollocore.SceneManager.PreviewSceneID then
      previewScene = _fNativeGetSceneByID(self,apollocore.SceneManager.PreviewSceneID);
    end
    return previewScene;
  end
  
  function apollocore.SceneManager:GetEditScene()
    local scene = nil;
    if apollocore.SceneManager.EditSceneID then
      scene = _fNativeGetSceneByID(self,apollocore.SceneManager.EditSceneID);
    end
    return scene;
  end
  
  function apollocore.SceneManager:GetEditSceneID()
    return apollocore.SceneManager.EditSceneID;
  end

  function apollocore.SceneManager:GetUISceneID()
    if apollocore.SceneManager.EditorUIID == nil then
      local scenes = _fNativeGetAllScene(self);
      for k,v in pairs(scenes) do
        local name = v:GetName();
        if name == "EditorUI" then
          apollocore.SceneManager.EditorUIID = v:GetStaticID();
        end
      end
    end
    return apollocore.SceneManager.EditorUIID;
  end
  
  --编辑器模式下清理Scene
  function apollocore.SceneManager:ClearScene()
    --删除EditorScene
    local editScene = _fNativeGetSceneByID(self,apollocore.SceneManager.EditSceneID);
    if editScene then
      apollocore.SceneManager.EditCamera = nil;
      apollocore.SceneManager.Grid = nil;
      _fNativeDeleteSceneByID(self,apollocore.SceneManager.EditSceneID);
      --清理其他Scene的Node(其他的Scene不能删除)
      if apollocore.SceneManager.PreviewSceneID then
        local preViewScene = _fNativeGetSceneByID(self,apollocore.SceneManager.PreviewSceneID);
        if preViewScene then
          local rootNode = preViewScene:GetRootNode();
          --把root的自node都删除掉
          local childNodes = rootNode:GetChildrens();
          for i = 1, #childNodes do
            preViewScene:DeleteNode(childNodes[i]);
          end
        end
      end
    end
  end
  
  --编辑器模式下拿到命令需要同步到的场景
  function apollocore.SceneManager:AddSyncScene(scene)
    if scene then
      local sceneID = scene:GetStaticID();
      if apollocore.SceneManager.SyncSceneList[sceneID] == nil then
        apollocore.SceneManager.SyncSceneList[sceneID] = scene;
      end
    end
  end
  
  function apollocore.SceneManager:GetSyncSceneList()
    return apollocore.SceneManager.SyncSceneList;
  end
  
  --编辑器下GetOrCreate就是GetPreviewScene
  apollocore.SceneManager.GetOrCreateScene = apollocore.SceneManager.GetPreviewScene;
end








