

local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local apollocore = require "apollocore"
local Stack = require "venuscore.stack"
local defined = require "apolloengine.defined"
local ParticleNode = require "apolloengine.nodes.particlenode"
local BundleSystem = require "venuscore.bundle.bundlesystem"
local SpineNode = require "apolloengine.nodes.spinenode"

venuscore.BundleSystem:OnSerialize("Layer",
        function(obj)
          return "string",tostring(tonumber(obj));
        end
)

venuscore.BundleSystem:OnSerialize("LayerMask",
        function(obj)
          return "string",tostring(tonumber(obj));
        end
)

local PhysicsFreq = 150;


local _fCreateNode = apollocore.Scene.CreateNode;
local _fDeleteNode = apollocore.Scene.DeleteNode;
local _fGetAllNodes = apollocore.Scene.GetAllNodes;
local _fSetSequence = apollocore.Scene.SetSequence;
local _fCreateDefaultRenderTarget = apollocore.Scene.CreateDefaultRenderTarget;


if _KRATOSEDITOR then
  function apollocore.Scene:Init()
    _fSetSequence(self,defined.SceneSequence.HIGH);
    _fCreateDefaultRenderTarget(self,mathfunction.vector2(128,128));
  end

  function apollocore.Scene:CreateGrid()
    local cellLength = 1.0;
    local cellCnt = 100;
    local material = "comm:documents/material/unlight_color.material";
    local sidelength = cellLength;
    local size = cellCnt;
    
    local gridNode = self:CreateGenericNode();
    gridNode:SetName("Grid");
    gridNode:SetLayer(apollocore.LayerMask.MC_MASK_EDITOR_SCENE_LAYER);
    
    local renderComponent = gridNode:CreateComponent(apollocore.Node.CT_RENDER);
    renderComponent:EraseRenderProperty(apollocore.RenderComponent.RP_CULL);
    renderComponent:SetBindBox(mathfunction.Aabbox3d(mathfunction.vector3(0,0,0),mathfunction.vector3(0,0,0)));--让grid无法被拾取
    
    local vertexStream = apollocore.VertexStream();
    local indexStream = apollocore.IndicesStream();
    vertexStream:SetVertexType(apollocore.ShaderEntity.ATTRIBUTE_POSITION,
      apollocore.VertexBufferEntity.DT_FLOAT,
      apollocore.VertexBufferEntity.DT_HALF_FLOAT,
      4);
    indexStream:SetIndicesType(
      apollocore.IndicesBufferEntity.IT_UINT16);
    
    vertexStream:ReserveBuffer(4 * size);--预先分配顶点的内存  4*n
    indexStream:ReserveBuffer(4 * size + 4);--4*n+4
    local val=size / 2;
    --LOG(val);

    for i=-val, val do   
      vertexStream:PushVertexData(
        apollocore.ShaderEntity.ATTRIBUTE_POSITION,
        mathfunction.vector4(i*sidelength,0,-val*sidelength,1));
      vertexStream:PushVertexData(
        apollocore.ShaderEntity.ATTRIBUTE_POSITION,
        mathfunction.vector4(i*sidelength,0,val*sidelength,1));
    end

    for i = 1-val,(val-1) do  
      vertexStream:PushVertexData(
        apollocore.ShaderEntity.ATTRIBUTE_POSITION,
        mathfunction.vector4(-val*sidelength,0,i*sidelength,1));
      vertexStream:PushVertexData(
        apollocore.ShaderEntity.ATTRIBUTE_POSITION,
        mathfunction.vector4(val*sidelength,0,i*sidelength,1));
    end
   
    for i=0,4*size-1 do  
      indexStream:PushIndicesData(i);
    end
    indexStream:PushIndicesData(0);
    indexStream:PushIndicesData(2*size);
    indexStream:PushIndicesData(1);
    indexStream:PushIndicesData(2*size+1); 
    
    renderComponent:PushMetadata(
      apollocore.RenderObjectMaterialMetadata(
        apollocore.PathMetadata(material)));

    renderComponent:PushMetadata(
      apollocore.RenderObjectMeshMetadate( 
        apollocore.RenderComponent.RM_LINES,
        apollocore.ReferenceVertexMetadata(        
          apollocore.VertexBufferEntity.MU_DYNAMIC,--使用可以修改的显存区域
          vertexStream),
        apollocore.ReferenceIndicesMetadata(
          apollocore.VertexBufferEntity.MU_STATIC,--使用不可修改的显存区域
          indexStream)));
    
    renderComponent:CreateResource();
    
    local gridColor = apollocore.IMaterialSystem:NewParameterSlot(apollocore.ShaderEntity.UNIFORM,"POINT_COLOR");
    renderComponent:SetParameter(gridColor,mathfunction.vector4(0.5,0.5,0.5,1.0));
    
    return gridNode;
  end

  function apollocore.Scene:CreateEditorCamera()  
    
    local size = mathfunction.vector2(128,128);
    local near = 0.1;
    local far = 100;
    local pos = mathfunction.vector3(0,1,4);
    local lookat = mathfunction.vector3(0,0,0);
    local up = mathfunction.vector3(0,1,0);
    local EditorCameraName = "EditorCamera";
    
    local rendertarget = apollocore.RenderTargetEntity();--创建一个FBO
    rendertarget:PushMetadata(--设置FBO格式
      apollocore.RenderTargetMetadata(
        apollocore.RenderTargetEntity.RT_RENDER_TARGET_2D,
        apollocore.RenderTargetEntity.ST_SWAP_UNIQUE,
        mathfunction.vector4(0,0,size:x(),size:y()),--视口大小
        size));--分辨率
    rendertarget:MakeBufferAttachment(apollocore.RenderTargetEntity.TA_DEPTH_STENCIL);--增加深度
    local outputtexture = rendertarget:MakeTextureAttachment(apollocore.RenderTargetEntity.TA_COLOR_0);--增加color0纹理
    outputtexture:PushMetadata(--创建纹理
          apollocore.TextureBufferMetadata(size));
    rendertarget:CreateResource();
    
    local cameraNode = self:CreateGenericNode();
    cameraNode:SetLayer(apollocore.LayerMask.MC_MASK_EDITOR_SCENE_LAYER);
    cameraNode:SetName(EditorCameraName);  --给一个默认的名字
    local cameraComponent = cameraNode:CreateComponent(apollocore.Node.CT_CAMERA);
    cameraComponent:FixedResolution(size);
    cameraComponent:SetLayerMaskEverything();
    cameraComponent:CreatePerspectiveProjection(near,far);
    cameraComponent:CreateRealCameraProjection(near,far);
    cameraComponent:LookAt(pos, lookat, up);
    cameraComponent:AttachRenderTarget(rendertarget);
    cameraComponent:Recalculate();
    cameraComponent:Activate();
    cameraComponent:SetClearColor(mathfunction.Color(0.2, 0.2, 0.2, 1.0));
    
    return cameraNode;
  end

end



--CreateGenericNode
function apollocore.Scene:CreateGenericNode()
  local node = _fCreateNode(self,apollocore.Node.CT_NODE);
  local trans = node:CreateComponent(apollocore.Node.CT_TRANSFORM);
  trans:SetLocalPosition(mathfunction.vector3(0.0,0.0,0.0));
  return node;
end

function apollocore.Scene:CreateTextNode(fontPath)
  local fontSize = 50;
  local textNode = _fCreateNode(self,apollocore.Node.CT_TEXT_NODE);
  local path = apollocore.PathMetadata(fontPath);
  path:SetSceneID(self:GetStaticID());
  textNode:PushMetadata(path);
  textNode:CreateResource();
  textNode.Size = mathfunction.vector2(fontSize,fontSize);
  textNode.Text = "Text";
  local trans = textNode:CreateComponent(apollocore.Node.CT_TRANSFORM);
  local render = textNode:CreateComponent(apollocore.Node.CT_RENDER);
  render:EraseRenderProperty(apollocore.RenderComponent.RP_CULL);
  local materialEntity = apollocore.MaterialEntity();
  materialEntity:PushMetadata(apollocore.MaterialMetadata("comm:documents/material/font2d.mat"));
  render:ChangeMaterial(materialEntity, 1);
  local vertexstream = apollocore.VertexStream();
  vertexstream:SetVertexType(apollocore.ShaderEntity.ATTRIBUTE_POSITION,
          apollocore.VertexBufferEntity.DT_FLOAT,
          apollocore.VertexBufferEntity.DT_HALF_FLOAT, 2);
  vertexstream:SetVertexType(apollocore.ShaderEntity.ATTRIBUTE_COORDNATE0,
          apollocore.VertexBufferEntity.DT_FLOAT,
          apollocore.VertexBufferEntity.DT_HALF_FLOAT, 2);
  vertexstream:SetVertexType(apollocore.ShaderEntity.ATTRIBUTE_COLOR0,
          apollocore.VertexBufferEntity.DT_FLOAT,
          apollocore.VertexBufferEntity.DT_HALF_FLOAT, 4);
  --创建索引流
  local indicesstream = apollocore.IndicesStream();
  indicesstream:SetIndicesType(
          apollocore.IndicesBufferEntity.IT_UINT16);
  render:PushMetadata(
          apollocore.RenderObjectMeshMetadate(
                  apollocore.RenderComponent.RM_TRIANGLES,
                  apollocore.ReferenceVertexMetadata(
                          apollocore.VertexBufferEntity.MU_DYNAMIC,--使用可以修改的显存区域
                          vertexstream),
                  apollocore.ReferenceIndicesMetadata(
                          apollocore.VertexBufferEntity.MU_DYNAMIC,--使用不可修改的显存区域
                          indicesstream)));
  render:CreateResource();
  textNode:RenderText();
  return textNode;
end

function apollocore.Scene:CreateSpineNode()
  local spineNode = SpineNode(self);
  return spineNode;
end

function apollocore.Scene:CreateJointNode()
end

function apollocore.Scene:CreateParticleNode()
  local particleNode = apollocore.ParticleNode(self);
  return particleNode;
end

function apollocore.Scene:EditorGizmo()

end


function apollocore.Scene:Deserialize(bufferStr, deserializeMode)
  local nodeList = BundleSystem:DeSerialize(bufferStr, self, deserializeMode);
  return nodeList;
end

function apollocore.Scene:_OnUpdate(node, def)
  --取出来的子node(subNodes)在脚本behavior中有可能被删掉
  --所以这里需要做个判断
  if not venuscore.isNil(node) then
    if node:isActiveHierarchy() then --如果非激活状态就不再更新
      local nodeName = node:GetName();
      --LOG("************************************** " .. nodeName);
      node:Update(def);
      local subNodes = node:GetChildrens();
      for k,v in pairs(subNodes) do
        self:_OnUpdate(v, def);
      end
    end
  end
  

end

function apollocore.Scene:Update(def)
  local rootNode = self:GetRootNode();
  self:_OnUpdate(rootNode, def);

  if apollocore.Scene.isRigidPlay==true then
    local physicWorld = self:GetPhysicWorld();
    local iteration = def * PhysicsFreq;
    local nClothCount = apollocore.IClothSystem:GetClothCount(self:GetStaticID());
    if nClothCount > 0 then
      apollocore.IClothSystem:BeginUpdate(PhysicsFreq, self:GetStaticID());
      for i = 1, iteration do
        physicWorld:Update(def, 1, 1/PhysicsFreq);
        physicWorld:UpdateDebug(def, 1 , 1/PhysicsFreq);
        apollocore.IClothSystem:Update(1.0/PhysicsFreq, self:GetStaticID());
      end   
      apollocore.IClothSystem:EndUpdate(self:GetStaticID()); 
    else
      physicWorld:Update(def, 10, 1/300);
      physicWorld:UpdateDebug(def, 10 , 1/300);
    end
   
  end
  
  if apollocore.Scene.isRigidPlay then
	local physicWorld = self:GetPhysicWorld();
	physicWorld:UpdateKinematics(0.2, 5);
  end
  
  
end

function apollocore.Scene:SetRigidPlay(isPlay)
  apollocore.Scene.isRigidPlay = isPlay;
end

function apollocore.Scene:_OnDeleteNode(node)
  local compList = node.Components;
  if compList then
    for key,value in pairs(compList) do
      value:Destroy();
    end
  end
  local subNodes = node:GetChildrens();
  for k,v in pairs(subNodes) do
    self:_OnDeleteNode(v);
  end
end

--hack一下：为了能正确删除behavior中创建的Node
function apollocore.Scene:DeleteNode(node)
  --如果通过UUID来删除的
  local dNode = node;
  if type(node) == "string" then
    dNode = self:GetNode(node);
  end
  self:_OnDeleteNode(dNode);
  _fDeleteNode(self,node);
end

--非编辑器模式下，方便调试Node的创建
if not _KRATOSEDITOR then
  --扩展CeateNode
  function apollocore.Scene:CreateNode(nodeType)
    local node = _fCreateNode(self,nodeType);
    --LOG("***********************apollocore.Scene:CreateNode");
    return node;
  end
end




