local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"

local TurbulentDisplace = {}
TurbulentDisplace.Do = 0;
TurbulentDisplace.Queue = 310;
TurbulentDisplace.amount = 1;
TurbulentDisplace.complexity = 1;
TurbulentDisplace.size = 4;
TurbulentDisplace.offset = mathfunction.vector2(0,0);
TurbulentDisplace.evolution = 0;

function TurbulentDisplace:Initialize(host, size)
  self.AMOUNT = apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "AMOUNT");

  self.COMPLEXITY = apolloengine.IMaterialSystem:NewParameterSlot(
          apolloengine.ShaderEntity.UNIFORM,
          "COMPLEXITY");
    
  self.SIZE = apolloengine.IMaterialSystem:NewParameterSlot(
          apolloengine.ShaderEntity.UNIFORM,
          "SIZE");

  self.OFFSET = apolloengine.IMaterialSystem:NewParameterSlot(
          apolloengine.ShaderEntity.UNIFORM,
          "OFFSET");

  self.EVOLUTION = apolloengine.IMaterialSystem:NewParameterSlot(
          apolloengine.ShaderEntity.UNIFORM,
          "EVOLUTION");
  
  local pathout = venuscore.IFileSystem:PathAssembly("comm:documents/material/turbulentdisplace.material");
  self.Do = host:CreateRenderObject(pathout);
  self.Do:SetParameter(self.AMOUNT,mathfunction.vector1(TurbulentDisplace.amount));
  self.Do:SetParameter(self.COMPLEXITY,mathfunction.vector1(TurbulentDisplace.complexity));
  self.Do:SetParameter(self.SIZE,mathfunction.vector1(TurbulentDisplace.size * 0.01));
  self.Do:SetParameter(self.OFFSET,TurbulentDisplace.offset);
  self.Do:SetParameter(self.EVOLUTION,mathfunction.vector1(TurbulentDisplace.evolution));
  
  host:RegisterScriptParameter(self,"amount");
  host:RegisterScriptParameter(self,"complexity");
  host:RegisterScriptParameter(self,"size");
  host:RegisterScriptParameter(self,"offset");
  host:RegisterScriptParameter(self,"evolution");
  return self.Queue;
end



function TurbulentDisplace:Resizeview(size)

end

function TurbulentDisplace:Process(pipeline, Original, Scene, Output)
  self.Do:SetParameter(self.AMOUNT,mathfunction.vector1(TurbulentDisplace.amount));
  self.Do:SetParameter(self.COMPLEXITY,mathfunction.vector1(TurbulentDisplace.complexity));
  self.Do:SetParameter(self.SIZE,mathfunction.vector1(TurbulentDisplace.size * 0.01));
  self.Do:SetParameter(self.OFFSET,TurbulentDisplace.offset);
  self.Do:SetParameter(self.EVOLUTION,mathfunction.vector1(TurbulentDisplace.evolution));
  Output:PushRenderTarget();
  Output:ClearBuffer( apolloengine.RenderTargetEntity.CF_COLOR );
  self.Do:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
	self.Do:Draw(pipeline);
end

return TurbulentDisplace;